package org.seasar.expr;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class NullifExp implements Expression {

	private final Expression _arg1Exp;
	private final Expression _arg2Exp;

	public NullifExp(final Expression arg1Exp, final Expression arg2Exp) {
		Assertion.assertNotNull("arg1Exp", arg1Exp);
		Assertion.assertNotNull("arg2Exp", arg2Exp);

		_arg1Exp = arg1Exp;
		_arg2Exp = arg2Exp;
	}

	public Object evaluateValue(final ExprContext context)
		throws SeasarException {

		Comparable arg1 = (Comparable) _arg1Exp.evaluateValue(context);
		Comparable arg2 = (Comparable) _arg2Exp.evaluateValue(context);
		if (arg1 != null && arg2 != null && arg1.compareTo(arg2) == 0) {
			return null;
		} else {
			return arg1;
		}
	}
}
