package org.seasar.expr;

import java.lang.reflect.Array;
import java.util.List;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class SetArrayVariableExp extends AbstractVariableExp {

	private Expression _indexExp;
	private Expression _argExp;

	public SetArrayVariableExp(
		final String name,
		final Expression indexExp,
		final Expression argExp) {

		super(name);
		Assertion.assertNotNull("indexExp", indexExp);
		Assertion.assertNotNull("argExp", argExp);

		_indexExp = indexExp;
		_argExp = argExp;
	}

	public Object evaluateValue(final ExprContext context)
		throws SeasarException {

		Number indexNum = (Number) _indexExp.evaluateValue(context);
		int index = indexNum.intValue();
		Object arg = _argExp.evaluateValue(context);
		Object target = context.getValue(_names[0]);
		for (int i = 1; i < _names.length; ++i) {
			target = ExprUtil.getProperty(target, _names[i]);
		}
		if (target instanceof List) {
			List list = (List) target;
			for (int i = list.size(); i <= index; ++i) {
				list.add(null);
			}
			list.set(index, arg);
		} else {
			Array.set(target, index, arg);
		}
		return arg;
	}
}
