package org.seasar.expr;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class SetVariableExp extends AbstractVariableExp {

	private Expression _exp;

	public SetVariableExp(final String name, final Expression exp) {
		super(name);
		Assertion.assertNotNull("exp", exp);

		_exp = exp;
	}

	public Object evaluateValue(final ExprContext context)
		throws SeasarException {

		Object value = _exp.evaluateValue(context);
		if (_names.length == 1) {
			context.setValue(_names[0], value);
		} else {
			Object target = context.getValue(_names[0]);
			for (int i = 1; i < _names.length - 1; ++i) {
				target = ExprUtil.getProperty(target, _names[i]);
			}
			ExprUtil.setProperty(target, _names[_names.length - 1], value);
		}
		return value;
	}
}
