package org.seasar.message;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class MessageFormatter {

    private static final String SEASAR_MESSAGES = "org.seasar.message.SSRMessages";
	private static String _configFile = "message-config";
    private static Map _messagesMap = new HashMap();

    static {
        try {
            setup();
        } catch (MissingResourceException ignore) {
        }
        if (_messagesMap.size() == 0) {
            _messagesMap.put("SSR", ResourceBundle.getBundle(SEASAR_MESSAGES));
        }
    }

    private MessageFormatter() {
    }
    
    public static void setConfigFile(String configFile) {
    	_configFile = configFile;
    }

    public static ResourceBundle getConfig() {
        return ResourceBundle.getBundle(_configFile);
    }

    public static String getSubSystem(final String messageCode) {
        return messageCode.substring(1, Math.min(4, messageCode.length()));
    }

    public static ResourceBundle getMessages(final String subSystem) {
        return (ResourceBundle) _messagesMap.get(subSystem);
    }

    public static String getPattern(final String messageCode) {
    	try {
	        ResourceBundle resourceBundle = getMessages(getSubSystem(messageCode));
	        if (resourceBundle != null) {
	            return resourceBundle.getString(messageCode);
	        }
    	} catch (Exception ignore) {
    	}
    	return null;
    }

    public static String getNoPatternMessage(final Object[] arguments) {
        if (arguments == null || arguments.length == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < arguments.length; i++) {
            buffer.append(arguments[i] + ", ");
        }
        buffer.setLength(buffer.length() - 2);
        return buffer.toString();
    }

    public static String getSimpleMessage(final String messageCode, final Object[] arguments) {
        String pattern = getPattern(messageCode);
        if (pattern != null) {
            return MessageFormat.format(pattern, arguments);
        } else {
            return getNoPatternMessage(arguments);
        }
    }

    public static String getMessage(String messageCode, final Object[] arguments) {
        if (messageCode ==  null) {
        	messageCode = "";
        }
        return "[" + messageCode + "]" + getSimpleMessage(messageCode, arguments);
    }

    public static void setup() {
        ResourceBundle config = getConfig();
        for (Enumeration e = config.getKeys(); e.hasMoreElements(); ) {
            String key = (String) e.nextElement();
            String resourceName = config.getString(key);
            _messagesMap.put(key, ResourceBundle.getBundle(resourceName));
        }
    }
    
    public static void clear() {
    	_messagesMap.clear();
    }
}