package org.seasar.nazuna;

import java.io.File;

import org.seasar.util.ResourceUtil;
import org.seasar.util.SeasarException;

public final class FlowletDeployer {

	private File _file;
	private long _lastModified = 0;
	private Flowlet _flowlet;
	private String _name;
	
	public FlowletDeployer(String name) {
		_name = name;
		_file = ResourceUtil.getFile(name, "xml");
	}
	
	public final File getFile() {
		return _file;
	}
	
	public final long getLastModified() {
		return _lastModified;
	}
	
	public final Flowlet getFlowlet() {
		return _flowlet;
	}

	public final synchronized void deploy() throws SeasarException {
		if (_file.lastModified() != _lastModified) {
        	_flowlet = FlowletBuilder.parse(_file);
        	_flowlet.setName(_name);
            _lastModified = _file.lastModified();
        }    
    }
}
