package org.seasar.nazuna;

import java.io.File;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;

import org.seasar.util.Conversion;
import org.seasar.util.SeasarException;
import org.seasar.util.SeasarRuntimeException;

public final class NazunaUtil {

	private NazunaUtil() {
	}

	public static boolean isConstName(String name) {
		for (int i = 0; i < name.length(); ++i) {
			char c = name.charAt(i);
			if (!isConstNameChar(c)) {
				return false;
			}
		}
		return true;
	}

	public static boolean isConstNameChar(char c) {
		return 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '_';
	}

	public static boolean isVarArgStartChar(char c) {
		return 'a' <= c && c <= 'z';
	}

	public static List filter(List items, String condition)
		throws SeasarException {

		return filter(items, condition, null);
	}

	public static List filter(List items, String condition, Map parameters)
		throws SeasarException {

		FilterDesc filterDesc = new FilterDesc(condition);
		return filterDesc.filter(items, parameters);
	}

	public static Object filterFirst(List items, String condition)
		throws SeasarException {

		return filterFirst(items, condition, null);
	}

	public static Object filterFirst(
		List items,
		String condition,
		Map parameters)
		throws SeasarException {

		FilterDesc filterDesc = new FilterDesc(condition);
		return filterDesc.filterFirst(items, parameters);
	}

	public static List sort(List items, String clause) throws SeasarException {

		SortDesc sortDesc = new SortDesc(clause);
		return sortDesc.sort(items);
	}

	public static List group(List items, String clause)
		throws SeasarException {

		GroupDesc groupDesc = new GroupDesc(clause);
		return groupDesc.group(items);
	}

	public static void appendToolsJarPath(StringBuffer buf) {
		String s = System.getProperty("java.home");
		int pos = s.lastIndexOf(File.separator);
		buf.append(s.substring(0, pos));
		buf.append(File.separator);
		buf.append("lib");
		buf.append(File.separator);
		buf.append("tools.jar");
	}

	public static String getToolsJarPath() {
		StringBuffer buf = new StringBuffer();
		appendToolsJarPath(buf);
		return buf.toString();
	}

	public static URL getToolsJarURL() {
		try {
			return new File(getToolsJarPath()).toURL();
		} catch (MalformedURLException ex) {
			throw SeasarRuntimeException.convertSeasarRuntimeException(ex);
		}
	}

	public static final Object adjustValue(Object value, Class valueClass) {
		if (valueClass.isPrimitive()) {
			if (valueClass == Integer.TYPE) {
				return Conversion.toInteger(value);
			} else if (valueClass == Double.TYPE) {
				return Conversion.toDouble(value);
			} else if (valueClass == Long.TYPE) {
				return Conversion.toLong(value);
			}
		} else {
			if (valueClass == Integer.class) {
				return Conversion.toInteger(value);
			} else if (valueClass == BigDecimal.class) {
				return Conversion.toBigDecimal(value);
			} else if (valueClass == Long.class) {
				return Conversion.toLong(value);
			} else if (valueClass == Double.class) {
				return Conversion.toDouble(value);
			}
		}
		return value;
	}
}
