package org.seasar.nazuna;

import java.util.Map;

import org.seasar.util.ElementHandler;
import org.seasar.util.Reflector;
import org.seasar.util.XMLHandler;
import org.seasar.util.XMLHandlerParser;
import org.seasar.util.XMLHandlerRule;
import org.xml.sax.Attributes;

public final class ResultTypeBuilder {

    private static XMLHandlerRule _xmlHandlerRule = new XMLHandlerRule();

	static {
		configure();
	}
	
	private static void configure() {
        setupXMLHandlerRule();
    }
	
    private ResultTypeBuilder() {
    }

    public static final ResultType parse(final String xmlFileName) {
        return (ResultType) XMLHandlerParser.parse(xmlFileName, _xmlHandlerRule);
    }

    private static void setupXMLHandlerRule() {
        _xmlHandlerRule.addElementHandler("/result",
            new ElementHandler() {
                public void start(XMLHandler xmlHandler, Attributes attributes) {
                	String className = attributes.getValue("className");
                	Class clazz = Reflector.getClass(className);
                	if (Map.class.isAssignableFrom(clazz)) {
						xmlHandler.push(new MapResultType(clazz)); 
                	} else {
						xmlHandler.push(new BeanResultType(clazz));
                	}
                    
                }
                public void end(final XMLHandler xmlHandler, final String body) {
	            	ResultType rt = (ResultType) xmlHandler.peek();
	            	rt.addPropertyTypeDone();
                }
            });
        _xmlHandlerRule.addElementHandler("/result/property",
            new ElementHandler() {
            	public void start(XMLHandler xmlHandler, Attributes attributes) {
            		ResultType resultType = (ResultType) xmlHandler.peek();
            		String name = attributes.getValue("name");
            		String columnName = attributes.getValue("columnName");
            		String typeName = attributes.getValue("type");
                    resultType.addPropertyType(name, columnName, typeName);
                }
            });
    }
}
