package org.seasar.nazuna;

import org.seasar.expr.*;
import org.seasar.util.SeasarException;

public class ReturnTag extends AbstractRuleStatement {
	
	private Expression _exp;
	
	public ReturnTag(Object parent, String location) {
		super(parent, location);
		_exp = NullExp.NULL;
	}
	
	public void setExpression(Expression exp) {
		_exp = exp;
	}
	
	public void execute(RuleContext ruleContext) throws SeasarException {
		try {
			Object value = _exp.evaluateValue(ruleContext);
			ruleContext.setReturnValue(value);
		} catch (Throwable t) {
			ruleContext.setThrowable(t, getLocation());
		}
	}

}
