package org.seasar.nazuna;

import org.seasar.expr.ExprUtil;
import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class SortElement {

    private String _propertyName;
    private SortType _sortType;

	public SortElement(String propertyName) {
		this(propertyName, SortType.ASC);
	}
	
    public SortElement(String propertyName, SortType sortType) {
    	Assertion.assertNotNull("propertyName", propertyName);
    	Assertion.assertNotNull("sortType", sortType);

        _propertyName = propertyName;
        _sortType = sortType;
    }

    public int compare(Object item1, Object item2) {
    	try {
        	Object o1 = ExprUtil.getProperty(item1, _propertyName);
        	Object o2 = ExprUtil.getProperty(item2, _propertyName);
        	return _sortType.compare(o1, o2);
    	} catch (SeasarException ex) {
    		throw ex.convertSeasarRuntimeException();
    	}
    }
}