package org.seasar.nazuna;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

import org.seasar.expr.*;
import org.seasar.util.Conversion;
import org.seasar.util.SeasarException;
import org.seasar.util.StringUtil;

public abstract class TextTagFragment {

	private static final String DELIM = "${}?";

	private TextTagFragment() {
	}

	public static TextTagFragment[] parse(String text) throws SeasarException {
		List list = new ArrayList();
		StringTokenizer st = new StringTokenizer(text, DELIM, true);
		while (st.hasMoreElements()) {
			String token = st.nextToken();
			if ("$".equals(token) || "?".equals(token)) {
				String s1 = st.nextToken();
				if (!"{".equals(s1)) {
					throw new SeasarException(
						"ESSR0033",
						new Object[] { s1, "{" });
				}
				String varName = st.nextToken();
				String s2 = st.nextToken();
				if (!"}".equals(s2)) {
					throw new SeasarException(
						"ESSR0033",
						new Object[] { s2, "}" });
				}
				Expression exp =
					new RuleStatementParser(varName).parseExpression();
				if ("$".equals(token)) {
					list.add(new ValueFragment(exp));
				} else {
					list.add(new BindVariableFragment(exp));
				}
			} else {
				list.add(new TextFragment(adjustToken(token)));
			}
		}
		return (TextTagFragment[]) list.toArray(
			new TextTagFragment[list.size()]);
	}

	public static String replaceToken(String token) {
		token = StringUtil.replace(token, " lt ", " < ");
		token = StringUtil.replace(token, " le ", " <= ");
		token = StringUtil.replace(token, " gt ", " > ");
		token = StringUtil.replace(token, " ge ", " >= ");
		token = StringUtil.replace(token, " eq ", " = ");
		token = StringUtil.replace(token, " ne ", " != ");
		return token;
	}

	public static String adjustToken(String token) {
		StringTokenizer st = new StringTokenizer(token, "\'", true);
		if (!st.hasMoreElements()) {
			return token;
		}
		StringBuffer buf = new StringBuffer(token.length());
		do {
			String s = st.nextToken();
			if (s.equals("\'")) {
				buf.append(s);
				while (st.hasMoreElements()) {
					String s2 = st.nextToken();
					if (s2.equals("\'")) {
						if (!st.hasMoreElements()) {
							buf.append(s2);
							break;
						}
						String s3 = st.nextToken();
						if (s3.equals("\'")) {
							buf.append("\'\'");
						} else {
							buf.append(s2);
							buf.append(replaceToken(s3));
							break;
						}
					} else {
						buf.append(s2);
					}
				}
			} else {
				buf.append(replaceToken(s));
			}
		}
		while (st.hasMoreElements());
		return buf.toString();
	}

	public abstract void execute(RuleContext ruleContext)
		throws SeasarException;

	private static class TextFragment extends TextTagFragment {

		private String _text;

		public TextFragment(String text) {
			_text = text;
		}

		public void execute(RuleContext ruleContext) {
			ruleContext.addText(_text);
		}
	}

	private static class ValueFragment extends TextTagFragment {

		private Expression _exp;

		public ValueFragment(Expression exp) {
			_exp = exp;
		}

		public void execute(RuleContext ruleContext) throws SeasarException {
			String text =
				Conversion.toString(_exp.evaluateValue(ruleContext), null);
			ruleContext.addText(text);
		}
	}

	private static class BindVariableFragment extends TextTagFragment {

		private Expression _exp;

		public BindVariableFragment(Expression exp) {
			_exp = exp;
		}

		public void execute(RuleContext ruleContext) throws SeasarException {
			Object bindVariable = _exp.evaluateValue(ruleContext);
			ruleContext.addText("?");
			ruleContext.addBindVariable(bindVariable);
		}
	}
}
