package org.seasar.nazuna;

import org.seasar.expr.*;
import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public class ThrowTag extends AbstractRuleStatement {

	private Expression _throwableExp;
	private String _messageCode;
	private NewArrayExp _newArrayExp;

	public ThrowTag(Object parent, String location) {
		super(parent, location);
	}

	public void execute(RuleContext ruleContext) throws SeasarException {
		try {
			executeReal(ruleContext);
		} catch (Throwable t) {
			ruleContext.setThrowable(t, getLocation());
		}
	}

	public final void executeReal(RuleContext ruleContext)
		throws SeasarException {
		Throwable throwable = getThrowable(ruleContext);
		ruleContext.setThrowable(throwable, getLocation());
	}

	public final void setMessageCode(String messageCode) {
		Assertion.assertNotNull("messageCode", messageCode);

		_messageCode = messageCode;
	}

	public final void setArgs(String args) throws SeasarException {
		if (args != null) {
			_newArrayExp =
				(NewArrayExp) new RuleStatementParser("new java.lang.Object[]{"
					+ args
					+ "}")
					.parseExpression();
		} else {
			_newArrayExp = NewArrayExp.EMPTY_ARRAY_EXP;
		}
	}

	public final void setThrowableExp(Expression throwableExp) {
		Assertion.assertNotNull("throwableExp", throwableExp);

		_throwableExp = throwableExp;
	}

	public final Throwable getThrowable(RuleContext ruleContext)
		throws SeasarException {

		if (_throwableExp != null) {
			return (Throwable) _throwableExp.evaluateValue(ruleContext);
		}
		return new SeasarException(_messageCode, getArgs(ruleContext));
	}

	public Object[] getArgs(final RuleContext ruleContext)
		throws SeasarException {

		return (Object[]) _newArrayExp.evaluateValue(ruleContext);
	}
}
