package org.seasar.sql;

import java.sql.Connection;
import java.sql.SQLException;

import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

import org.seasar.transaction.DefaultXAResource;
import org.seasar.util.SeasarRuntimeException;

public class SQLXAResource extends DefaultXAResource {

	private XAConnectionImpl _xaConnection;
    private Connection _physicalConnection;

    public SQLXAResource(final XAConnectionImpl xaConnection, final Connection physicalConnection) {
    	if (xaConnection == null) {
            throw new SeasarRuntimeException("ESSR0007", new Object[]{"xaConnection"});
        }
        _xaConnection = xaConnection;
        if (physicalConnection == null) {
            throw new SeasarRuntimeException("ESSR0007", new Object[]{"physicalConnection"});
        }
        _physicalConnection = physicalConnection;
    }

    protected void doBegin(final Xid xid) throws XAException {
        try {
            if (_physicalConnection.getAutoCommit()) {
                _physicalConnection.setAutoCommit(false);
            }
        } catch (SQLException ex) {
        	_xaConnection.notifyError(ex);
            throw new XAException(ex.toString());
        }
    }

    protected void doCommit(final Xid xid, final boolean onePhase) throws XAException {
        try {
            _physicalConnection.commit();
            _physicalConnection.setAutoCommit(true);
        } catch (SQLException ex) {
        	_xaConnection.notifyError(ex);
            throw new XAException(ex.toString());
        }
    }

    protected int doPrepare(final Xid xid) throws XAException {
        try {
            if (_physicalConnection.isClosed()) {
                return XA_RDONLY;
            } else {
                return XA_OK;
            }
        } catch (SQLException ex) {
        	_xaConnection.notifyError(ex);
            throw new XAException(ex.toString());
        }
    }

    protected void doRollback(final Xid xid) throws XAException {
        try {
            _physicalConnection.rollback();
            _physicalConnection.setAutoCommit(true);
        } catch (SQLException ex) {
        	_xaConnection.notifyError(ex);
            throw new XAException(ex.toString());
        }
    }
}