package test.org.seasar.expr;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.expr.AndExp;
import org.seasar.expr.BooleanExp;
import org.seasar.expr.BooleanExpression;
import org.seasar.expr.IntegerExp;

public class AndExpTest extends TestCase {

    public AndExpTest(String name) {
        super(name);
    }

	public void testEvaluate() throws Exception {
		BooleanExpression exp = new AndExp(BooleanExp.TRUE, BooleanExp.TRUE);
		assertEquals("1", true, exp.evaluate(null));
	}

	public void testEvaluate2() throws Exception {
		IntegerExp iExp = new IntegerExp(new Integer(1));
		BooleanExpression exp = new AndExp(BooleanExp.TRUE, BooleanExp.FALSE);
		assertEquals("1", false, exp.evaluate(null));
	}

	public void testEvaluate3() throws Exception {
		BooleanExpression exp = new AndExp(BooleanExp.FALSE, BooleanExp.TRUE);
		assertEquals("1", false, exp.evaluate(null));
	}

	public void testEvaluate4() throws Exception {
		BooleanExpression exp = new AndExp(BooleanExp.FALSE, BooleanExp.FALSE);
		assertEquals("1", false, exp.evaluate(null));
	}

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(AndExpTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{AndExpTest.class.getName()});
    }
}