package test.org.seasar.expr;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.expr.BetweenExp;
import org.seasar.expr.BooleanExpression;
import org.seasar.expr.IntegerExp;
import org.seasar.expr.NullExp;

public class BetweenExpTest extends TestCase {

	public BetweenExpTest(String name) {
		super(name);
	}

	public void testEvaluate() throws Exception {
		IntegerExp arg1Exp = new IntegerExp(new Integer(5));
		IntegerExp fromExp = new IntegerExp(new Integer(1));
		IntegerExp toExp = new IntegerExp(new Integer(10));
		BooleanExpression exp = new BetweenExp(arg1Exp, fromExp, toExp);
		assertEquals("1", true, exp.evaluate(null));
	}

	public void testEvaluate2() throws Exception {
		IntegerExp arg1Exp = new IntegerExp(new Integer(1));
		IntegerExp fromExp = new IntegerExp(new Integer(1));
		IntegerExp toExp = new IntegerExp(new Integer(10));
		BooleanExpression exp = new BetweenExp(arg1Exp, fromExp, toExp);
		assertEquals("1", true, exp.evaluate(null));
	}

	public void testEvaluate3() throws Exception {
		IntegerExp arg1Exp = new IntegerExp(new Integer(10));
		IntegerExp fromExp = new IntegerExp(new Integer(1));
		IntegerExp toExp = new IntegerExp(new Integer(10));
		BooleanExpression exp = new BetweenExp(arg1Exp, fromExp, toExp);
		assertEquals("1", true, exp.evaluate(null));
	}

	public void testEvaluate4() throws Exception {
		IntegerExp arg1Exp = new IntegerExp(new Integer(0));
		IntegerExp fromExp = new IntegerExp(new Integer(1));
		IntegerExp toExp = new IntegerExp(new Integer(10));
		BooleanExpression exp = new BetweenExp(arg1Exp, fromExp, toExp);
		assertEquals("1", false, exp.evaluate(null));
	}

	public void testEvaluate5() throws Exception {
		IntegerExp arg1Exp = new IntegerExp(new Integer(11));
		IntegerExp fromExp = new IntegerExp(new Integer(1));
		IntegerExp toExp = new IntegerExp(new Integer(10));
		BooleanExpression exp = new BetweenExp(arg1Exp, fromExp, toExp);
		assertEquals("1", false, exp.evaluate(null));
	}

	public void testEvaluate6() throws Exception {
		IntegerExp arg1Exp = new IntegerExp(new Integer(1));
		IntegerExp toExp = new IntegerExp(new Integer(10));
		BooleanExpression exp = new BetweenExp(arg1Exp, NullExp.NULL, toExp);
		assertEquals("1", false, exp.evaluate(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(BetweenExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { BetweenExpTest.class.getName()});
	}
}