package test.org.seasar.expr;

import java.util.ArrayList;
import java.util.List;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.expr.CoalesceExp;
import org.seasar.expr.ExprUtil;
import org.seasar.expr.Expression;
import org.seasar.expr.NullExp;
import org.seasar.expr.StringExp;

public class CoalesceExpTest extends TestCase {

	public CoalesceExpTest(String name) {
		super(name);
	}

	public void testEvaluate() throws Exception {
		List expList = new ArrayList();
		expList.add(NullExp.NULL);
		expList.add(new StringExp("111"));
		Expression exp = new CoalesceExp(ExprUtil.toExpressionArray(expList));
		assertEquals("1", "111", exp.evaluateValue(null));
	}

	public void testEvaluate2() throws Exception {
		List expList = new ArrayList();
		expList.add(new StringExp("222"));
		expList.add(new StringExp("111"));
		Expression exp = new CoalesceExp(ExprUtil.toExpressionArray(expList));
		assertEquals("1", "222", exp.evaluateValue(null));
	}

	public void testEvaluate3() throws Exception {
		List expList = new ArrayList();
		expList.add(NullExp.NULL);
		expList.add(NullExp.NULL);
		Expression exp = new CoalesceExp(ExprUtil.toExpressionArray(expList));
		assertEquals("1", null, exp.evaluateValue(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(CoalesceExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { CoalesceExpTest.class.getName()});
	}
}