package test.org.seasar.expr;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.expr.DivideExp;
import org.seasar.expr.DoubleExp;
import org.seasar.expr.IntegerExp;
import org.seasar.expr.LongExp;

public class DivideExpTest extends TestCase {

	public DivideExpTest(String name) {
		super(name);
	}

	public void testDivide() throws Exception {
		IntegerExp i1Exp = new IntegerExp(new Integer(5));
		IntegerExp i2Exp = new IntegerExp(new Integer(2));
		DivideExp exp = new DivideExp(i1Exp, i2Exp);
		assertEquals("1", new Integer(2), exp.evaluateValue(null));
	}

	public void testDivide2() throws Exception {
		LongExp long1Exp = new LongExp(new Long(5));
		LongExp long2Exp = new LongExp(new Long(2));
		DivideExp exp = new DivideExp(long1Exp, long2Exp);
		assertEquals("1", new Long(2), exp.evaluateValue(null));
	}

	public void testDivide3() throws Exception {
		DoubleExp double1Exp = new DoubleExp(new Double(5));
		DoubleExp double2Exp = new DoubleExp(new Double(2));
		DivideExp exp = new DivideExp(double1Exp, double2Exp);
		assertEquals("1", new Double(2.5), exp.evaluateValue(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(DivideExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { DivideExpTest.class.getName()});
	}
}