package test.org.seasar.expr;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.expr.BooleanExp;
import org.seasar.expr.BooleanExpression;
import org.seasar.expr.IsFalseExp;

public class IsFalseExpTest extends TestCase {

	public IsFalseExpTest(String name) {
		super(name);
	}

	public void testEvaluate() throws Exception {
		BooleanExpression exp = new IsFalseExp(BooleanExp.TRUE);
		assertEquals("1", false, exp.evaluate(null));
	}

	public void testEvaluate2() throws Exception {
		BooleanExpression exp = new IsFalseExp(BooleanExp.FALSE);
		assertEquals("1", true, exp.evaluate(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(IsFalseExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { IsFalseExpTest.class.getName()});
	}
}