package test.org.seasar.expr;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.expr.BooleanExpression;
import org.seasar.expr.IntegerExp;
import org.seasar.expr.IsNullExp;
import org.seasar.expr.NullExp;

public class IsNullExpTest extends TestCase {

	public IsNullExpTest(String name) {
		super(name);
	}

	public void testEvaluate() throws Exception {
		BooleanExpression exp = new IsNullExp(NullExp.NULL);
		assertEquals("1", true, exp.evaluate(null));
	}

	public void testEvaluate2() throws Exception {
		IntegerExp arg1Exp = new IntegerExp(new Integer(2));
		BooleanExpression exp = new IsNullExp(arg1Exp);
		assertEquals("1", false, exp.evaluate(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(IsNullExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { IsNullExpTest.class.getName()});
	}
}