package test.org.seasar.expr;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.expr.BooleanExp;
import org.seasar.expr.BooleanExpression;
import org.seasar.expr.IsTrueExp;

public class IsTrueExpTest extends TestCase {

    public IsTrueExpTest(String name) {
        super(name);
    }

	public void testEvaluate() throws Exception {
        BooleanExpression exp = new IsTrueExp(BooleanExp.TRUE);
        assertEquals("1", true, exp.evaluate(null));
    }
    
	public void testEvaluate2() throws Exception {
		BooleanExpression exp = new IsTrueExp(BooleanExp.FALSE);
		assertEquals("1", false, exp.evaluate(null));
	}
    
    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(IsTrueExpTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{IsTrueExpTest.class.getName()});
    }
}