package test.org.seasar.expr;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.expr.IntegerExp;
import org.seasar.expr.LessEqualExp;
import org.seasar.expr.NullExp;

public class LessEqualExpTest extends TestCase {

	public LessEqualExpTest(String name) {
		super(name);
	}

	public void testEvaluate() throws Exception {
		String s = "1234567890";
		String s2 = "1234567891";
		Integer i = new Integer(s);
		Integer i2 = new Integer(s2);
		IntegerExp iExp = new IntegerExp(i);
		IntegerExp i2Exp = new IntegerExp(i2);
		LessEqualExp leExp = new LessEqualExp(iExp, iExp);
		assertEquals("1", true, leExp.evaluate(null));

		LessEqualExp le2Exp = new LessEqualExp(i2Exp, iExp);
		assertEquals("2", false, le2Exp.evaluate(null));

		LessEqualExp le3Exp = new LessEqualExp(iExp, i2Exp);
		assertEquals("3", true, le3Exp.evaluate(null));

		LessEqualExp le4Exp = new LessEqualExp(iExp, NullExp.NULL);
		assertEquals("4", false, le4Exp.evaluate(null));

		LessEqualExp le5Exp = new LessEqualExp(NullExp.NULL, iExp);
		assertEquals("5", false, le5Exp.evaluate(null));

		LessEqualExp le6Exp = new LessEqualExp(NullExp.NULL, NullExp.NULL);
		assertEquals("6", false, le6Exp.evaluate(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(LessEqualExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { LessEqualExpTest.class.getName()});
	}
}