package test.org.seasar.expr;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.expr.DoubleExp;
import org.seasar.expr.IntegerExp;
import org.seasar.expr.LongExp;
import org.seasar.expr.MultiplyExp;
import org.seasar.expr.NullExp;

public class MultiplyExpTest extends TestCase {

	public MultiplyExpTest(String name) {
		super(name);
	}

	public void testMultiply() throws Exception {
		IntegerExp i1Exp = new IntegerExp(new Integer(2));
		IntegerExp i2Exp = new IntegerExp(new Integer(3));
		MultiplyExp exp = new MultiplyExp(i1Exp, i2Exp);
		assertEquals("1", new Integer(6), exp.evaluateValue(null));
	}

	public void testMultiply2() throws Exception {
		LongExp long1Exp = new LongExp(new Long(2));
		LongExp long2Exp = new LongExp(new Long(3));
		MultiplyExp exp = new MultiplyExp(long1Exp, long2Exp);
		assertEquals("1", new Long(6), exp.evaluateValue(null));
	}

	public void testMultiply3() throws Exception {
		DoubleExp double1Exp = new DoubleExp(new Double(2));
		DoubleExp double2Exp = new DoubleExp(new Double(3));
		MultiplyExp exp = new MultiplyExp(double1Exp, double2Exp);
		assertEquals("1", new Double(6), exp.evaluateValue(null));
	}

	public void testMultiply4() throws Exception {
		IntegerExp i1Con = new IntegerExp(new Integer(1));
		MultiplyExp exp = new MultiplyExp(i1Con, NullExp.NULL);
		assertEquals("1", null, exp.evaluateValue(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(MultiplyExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { MultiplyExpTest.class.getName()});
	}
}