package test.org.seasar.expr;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.expr.IntegerExp;
import org.seasar.expr.NotEqualExp;
import org.seasar.expr.NullExp;

public class NotEqualExpTest extends TestCase {

	public NotEqualExpTest(String name) {
		super(name);
	}

	public void testEvaluate() throws Exception {
		String s = "1234567890";
		String s2 = "1234567891";
		Integer i = new Integer(s);
		Integer i2 = new Integer(s2);
		IntegerExp iExp = new IntegerExp(i);
		IntegerExp i2Exp = new IntegerExp(i2);
		NotEqualExp neExp = new NotEqualExp(iExp, iExp);
		assertEquals("1", false, neExp.evaluate(null));

		NotEqualExp ne2Exp = new NotEqualExp(i2Exp, iExp);
		assertEquals("2", true, ne2Exp.evaluate(null));

		NotEqualExp ge3Exp = new NotEqualExp(iExp, i2Exp);
		assertEquals("3", true, ge3Exp.evaluate(null));

		NotEqualExp ne4Exp = new NotEqualExp(iExp, NullExp.NULL);
		assertEquals("4", true, ne4Exp.evaluate(null));

		NotEqualExp ne5Exp = new NotEqualExp(NullExp.NULL, iExp);
		assertEquals("5", true, ne5Exp.evaluate(null));

		NotEqualExp ne6Exp = new NotEqualExp(NullExp.NULL, NullExp.NULL);
		assertEquals("6", false, ne6Exp.evaluate(null));

	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(NotEqualExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { NotEqualExpTest.class.getName()});
	}
}