package test.org.seasar.expr;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.expr.Expression;
import org.seasar.expr.NullifExp;
import org.seasar.expr.StringExp;

public class NullifExpTest extends TestCase {

	public NullifExpTest(String name) {
		super(name);
	}

	public void testEvaluateValue() throws Exception {
		Expression arg1Exp = new StringExp("aaa");
		Expression exp = new NullifExp(arg1Exp, arg1Exp);
		assertEquals("1", null, exp.evaluateValue(null));
	}

	public void testEvaluateValue2() throws Exception {
		Expression arg1Exp = new StringExp("aaa");
		Expression arg2Exp = new StringExp("bbb");
		Expression exp = new org.seasar.expr.NullifExp(arg1Exp, arg2Exp);
		assertEquals("1", "aaa", exp.evaluateValue(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(NullifExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { NullifExpTest.class.getName()});
	}
}