package test.org.seasar.expr;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.expr.Expression;
import org.seasar.expr.NullExp;
import org.seasar.expr.NvlExp;
import org.seasar.expr.StringExp;

public class NvlExpTest extends TestCase {

	public NvlExpTest(String name) {
		super(name);
	}

	public void testEvaluateValue() throws Exception {
		Expression arg2Exp = new StringExp("aaa");
		Expression exp = new NvlExp(NullExp.NULL, arg2Exp);
		assertEquals("1", "aaa", exp.evaluateValue(null));
	}

	public void testEvaluateValue2() throws Exception {
		Expression arg1Exp = new StringExp("aaa");
		Expression exp = new NvlExp(arg1Exp, NullExp.NULL);
		assertEquals("1", "aaa", exp.evaluateValue(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(NvlExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { NvlExpTest.class.getName()});
	}
}