package test.org.seasar.expr;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.expr.DoubleExp;
import org.seasar.expr.Expression;
import org.seasar.expr.IntegerExp;
import org.seasar.expr.LongExp;
import org.seasar.expr.NullExp;
import org.seasar.expr.SubtractExp;

public class SubtractExpTest extends TestCase {

	public SubtractExpTest(String name) {
		super(name);
	}

	public void testSubtract() throws Exception {
		IntegerExp i1Exp = new IntegerExp(new Integer(1));
		IntegerExp i2Exp = new IntegerExp(new Integer(2));
		SubtractExp exp = new SubtractExp(i1Exp, i2Exp);
		assertEquals("1", new Integer(-1), exp.evaluateValue(null));
	}

	public void testSubtract2() throws Exception {
		Expression long1Exp = new LongExp(new Long(1));
		Expression long2Exp = new LongExp(new Long(2));
		SubtractExp exp = new SubtractExp(long1Exp, long2Exp);
		assertEquals("1", new Long(-1), exp.evaluateValue(null));
	}

	public void testSubtract3() throws Exception {
		DoubleExp double1Exp = new DoubleExp(new Double(1));
		DoubleExp double2Exp = new DoubleExp(new Double(2));
		SubtractExp exp = new SubtractExp(double1Exp, double2Exp);
		assertEquals("1", new Double(-1), exp.evaluateValue(null));
	}

	public void testSubtract4() throws Exception {
		IntegerExp i1Exp = new IntegerExp(new Integer(1));
		SubtractExp exp = new SubtractExp(i1Exp, NullExp.NULL);
		assertEquals("1", null, exp.evaluateValue(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(SubtractExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { SubtractExpTest.class.getName()});
	}
}