package test.org.seasar.mbean;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.seasar.mbean.MBeanFacade;
import org.seasar.system.JMXService;
import org.seasar.system.JMXUtil;
import org.seasar.util.SeasarContext;
import org.seasar.util.SeasarException;

import test.org.seasar.naming.NamingTestCase;
import test.org.seasar.system.Hello;
import test.org.seasar.system.HelloMBean;

public class MBeanFacadeTest extends NamingTestCase {

	private MBeanFacade _mbeanFacade;
	
    public MBeanFacadeTest(String name) throws Exception {
        super(name);
    }

	public void testStartAndStop() throws Exception {
		SeasarContext ctx = SeasarContext.getInstance();
		_mbeanFacade = new MBeanFacade(Hello.class.getName(), null);
    	_mbeanFacade.start();
    	try {
    		Hello mbean = (Hello) _mbeanFacade.getMBean();
    		assertNotNull("1", mbean);
			HelloMBean proxy = (HelloMBean) ctx.lookupNoCache(JMXUtil.getJNDIName("Hello"));
			assertNotNull("2", proxy);
			assertEquals("3", "hello", proxy.greeting());
    	} finally {
    		_mbeanFacade.stop();
    	}
    	try {
    		ctx.lookupNoCache(JMXUtil.getJNDIName("Hello"));
    		fail("4");
    	} catch (SeasarException ex) {
    		System.out.println(ex);
    	}
    	assertEquals("5", false, JMXService.isRegistered(JMXUtil.getMBeanName("Hello")));
	}

    protected void setUp() throws Exception {
    	super.setUp();    	
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public static Test suite() {
        return new TestSuite(MBeanFacadeTest.class);
    }

    public static void main(String[] args) {
        junit.textui.TestRunner.main(new String[]{MBeanFacadeTest.class.getName()});
    }
}