package test.org.seasar.nazuna;

import java.util.List;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.seasar.expr.Expression;
import org.seasar.nazuna.RuleStatementParser;

import test.org.seasar.sql.ConnectionPoolTestCase;

public class ExecuteQueryTest extends ConnectionPoolTestCase {

	public ExecuteQueryTest(String name) {
		super(name);
	}

	public void testDoExecute() throws Exception {
		String s = "executeQuery('/test/org/seasar/nazuna/select.xml')";
		Expression exp = new RuleStatementParser(s).parseExpression();
		List ret = (List) exp.evaluateValue(null);
		assertEquals("1", 14, ret.size());
	}

	public void testParse() throws Exception {
		String s =
			"executeQuery('/test/org/seasar/nazuna/selectWhere.xml', 7788)";
		Expression exp = new RuleStatementParser(s).parseExpression();
		List ret = (List) exp.evaluateValue(null);
		assertEquals("1", 1, ret.size());
	}

	protected void setUp() throws Exception {
		super.setUp();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public static Test suite() {
		return new TestSuite(ExecuteQueryTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { ExecuteQueryTest.class.getName()});
	}
}