package test.org.seasar.nazuna;

import junit.framework.*;
import java.util.*;
import java.math.*;
import org.seasar.util.*;
import org.seasar.nazuna.*;

public class GroupDescTest extends TestCase {

    public GroupDescTest(String name) throws Exception {
        super(name);
    }

    public void testGroupEmpty() throws Exception {
    	GroupDesc groupDesc = new GroupDesc(new String[]{"a"}, new GroupElement[]
    		{new GroupElement("aSum", GroupType.SUM, "a")});
    	List items = new EArrayList();
    	List ret = groupDesc.group(items);
        assertEquals("1", 0, ret.size());
    }
    
    public void testGroupOne() throws Exception {
    	GroupDesc groupDesc = new GroupDesc(new String[]{"a"}, new GroupElement[]
    		{new GroupElement("aSum", GroupType.SUM, "a")});
    	List items = new EArrayList();
    	Map item = new EMap();
    	item.put("a", new Integer(1));
    	items.add(item);
    	List ret = groupDesc.group(items);
        assertEquals("1", 1, ret.size());
        EMap retItem = (EMap) ret.get(0);
        assertEquals("2", "a", retItem.getKey(0));
        assertEquals("3", "aSum", retItem.getKey(1));
        assertEquals("4", new Integer(1), retItem.get(0));
        assertEquals("5", new BigDecimal(1), retItem.get(1));
    }
    
    public void testGroupMulti() throws Exception {
    	GroupDesc groupDesc = new GroupDesc(new String[]{"b"}, new GroupElement[]
    		{new GroupElement("aSum", GroupType.SUM, "a")});
    	List items = new EArrayList();
    	Map item = new EMap();
    	item.put("a", new Integer(1));
    	item.put("b", "1");
    	items.add(item);
    	item = new EMap();
    	item.put("a", new Integer(2));
    	item.put("b", "1");
    	items.add(item);
    	item = new EMap();
    	item.put("a", new Integer(4));
    	item.put("b", "2");
    	items.add(item);
    	List ret = groupDesc.group(items);
        assertEquals("1", 2, ret.size());
        EMap retItem = (EMap) ret.get(0);
        assertEquals("2", "b", retItem.getKey(0));
        assertEquals("3", "aSum", retItem.getKey(1));
        assertEquals("4", "1", retItem.get(0));
        assertEquals("5", new BigDecimal(3), retItem.get(1));
        retItem = (EMap) ret.get(1);
        assertEquals("5", "2", retItem.get(0));
        assertEquals("6", new BigDecimal(4), retItem.get(1));
    }
    
    public void testConstructor() throws Exception {
    	GroupDesc groupDesc = new GroupDesc(
    		"a, b, count(*), sum(c) as csum, max(d), min(e), avg(f) favg, count(g)");
    	String[] keys = groupDesc.getKeys();
    	GroupElement[] groupElements = groupDesc.getGroupElements();
    	assertEquals("1", 2, keys.length);
    	assertEquals("2", "a", keys[0]);
    	assertEquals("3", "b", keys[1]);
    	assertEquals("4", 6, groupElements.length);
    	assertEquals("5", "_0", groupElements[0].getPropertyName());
    	assertEquals("6", GroupType.COUNT, groupElements[0].getGroupType());
    	assertEquals("7", null, groupElements[0].getGroupedPropertyName());
    	
    }
    
    
    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite() {
        return new TestSuite(GroupDescTest.class);
    }

    public static void main(String[] args) {
        junit.textui.TestRunner.main(new String[]{GroupDescTest.class.getName()});
    }
}
