package test.org.seasar.nazuna;

import java.net.URL;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.expr.ExprUtil;
import org.seasar.nazuna.NazunaUtil;
import org.seasar.util.ArrayUtil;

public class NazunaUtilTest extends TestCase {
		
    public NazunaUtilTest(String name) {
        super(name);
    }

    public void testIsConstNameChar() throws Exception {
    	assertTrue("1", NazunaUtil.isConstNameChar('A'));
    	assertTrue("2", NazunaUtil.isConstNameChar('1'));
    	assertTrue("3", NazunaUtil.isConstNameChar('_'));
    	assertTrue("4", !NazunaUtil.isConstNameChar('a'));
    }
    
    public void testGetToolsJarURL() throws Exception {
    	URL url = NazunaUtil.getToolsJarURL();
    	System.out.println(url);
    	assertNotNull("1", url);
    }
    
    public void testGetClass() throws Exception {
    	Class clazz = ExprUtil.getClass("[Ljava.lang.String;");
    	assertEquals("1", ArrayUtil.EMPTY_STRINGS.getClass(), clazz);
    	
    	Class clazz2 = ExprUtil.getClass("java.lang.String[]");
    	assertEquals("2", ArrayUtil.EMPTY_STRINGS.getClass(), clazz2);
    }
        
    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(NazunaUtilTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{NazunaUtilTest.class.getName()});
    }
}