package test.org.seasar.nazuna;

import java.util.Map;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.ArgType;
import org.seasar.nazuna.Flowlet;
import org.seasar.nazuna.InputType;
import org.seasar.nazuna.RuleContext;
import org.seasar.nazuna.RuleContextImpl;
import org.seasar.nazuna.RuleStatementParser;
import org.seasar.expr.Expression;
import org.seasar.util.EMap;
import org.seasar.util.SeasarException;

public class RuleContextTest extends TestCase {

	public RuleContextTest(String name) {
		super(name);
	}

	public void testSetArgValue() throws Exception {
		Flowlet rule = new Flowlet();
		InputType inputType = new InputType();
		ArgType argType = new ArgType("aaa", String.class);
		inputType.addArgType(argType);
		rule.setInputType(inputType);

		Expression exp = new RuleStatementParser("aaa := 'abc'").parseExpression();
		Map parameters = new EMap();
		parameters.put("aaa", null);
		RuleContext ruleContext = new RuleContextImpl(rule, parameters);
		exp.evaluateValue(ruleContext);
		assertEquals("1", "abc", ruleContext.getValue("aaa"));
	}

	public void testSetVarValue2() throws Exception {
		Flowlet rule = new Flowlet();
		rule.addConst("AAA", "111");

		Expression exp = new RuleStatementParser("AAA := 'abc'").parseExpression();
		RuleContext ruleContext = new RuleContextImpl(rule, null);
		try {
			exp.evaluateValue(ruleContext);
			fail("1");
		} catch (SeasarException ex) {
			System.out.println(ex);
		}
	}

	public void testSetVarValue3() throws Exception {
		Flowlet rule = new Flowlet();

		Expression exp = new RuleStatementParser("aaa := 'abc'").parseExpression();
		Map parameters = new EMap();
		parameters.put("aaa", null);
		RuleContext ruleContext = new RuleContextImpl(rule, parameters);
		try {
			exp.evaluateValue(ruleContext);
			fail("1");
		} catch (SeasarException ex) {
			System.out.println(ex);
		}
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(RuleContextTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { RuleContextTest.class.getName()});
	}
}