package test.org.seasar.nazuna;

import java.io.File;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.Nazuna;
import org.seasar.nazuna.RuletClassLoader;
import org.seasar.util.ResourceUtil;

public class RuletClassLoaderTest extends TestCase {

    public RuletClassLoaderTest(String name) {
        super(name);
    }

    public void testDefineClass() throws Exception {
    	RuletClassLoader loader = new RuletClassLoader();
    	RuletClassLoader loader2 = new RuletClassLoader();
    	File file = ResourceUtil.getFile("/test/org/seasar/nazuna/HelloRulet.class");
    	assertNotNull("1", loader.defineClass("test.org.seasar.nazuna.HelloRulet", file));
    	assertNotNull("2", loader2.defineClass("test.org.seasar.nazuna.HelloRulet", file));
    }
    
	public void testSpike() throws Exception {
		assertEquals("1", "Hello", Nazuna.executeRulet("test.org.seasar.nazuna.TestRulet3"));
		//assertEquals("2", "Hello", Nazuna.executeRulet("test.org.seasar.nazuna.TestRulet4"));
	}

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(RuletClassLoaderTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{RuletClassLoaderTest.class.getName()});
    }
}