package test.org.seasar.sql;

import java.sql.Connection;
import java.util.Properties;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.sql.ConnectionPool;
import org.seasar.sql.ConnectionPoolMetaData;
import org.seasar.sql.SQLXAResource;
import org.seasar.sql.XAConnectionImpl;
import org.seasar.transaction.TransactionManagerImpl;

public class ConnectionPoolTest extends TestCase {

    private ConnectionPool _pool;

    public ConnectionPoolTest(String name) {
        super(name);
    }

    public void testRequestConnection() throws Exception {
        Runnable r = new Runnable() {
            public void run() {
                try {
                    XAConnectionImpl xaCon = _pool.requestXAConnection();
                    Thread.sleep(5000);
                    _pool.returnXAConnection(xaCon);
                    System.out.println("returnXAConnection");
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        Thread th = new Thread(r);
        th.start();
        while (_pool.getPoolSize() == 0) {
            Thread.sleep(100);
        }
        XAConnectionImpl xaCon = _pool.requestXAConnection();
        _pool.returnXAConnection(xaCon);
    }

    public void testReuseConnection() throws Exception {
        XAConnectionImpl xaCon = _pool.requestXAConnection();
        _pool.returnXAConnection(xaCon);
        XAConnectionImpl xaCon2 = _pool.requestXAConnection();
        assertEquals("1", xaCon, xaCon2);
        _pool.returnXAConnection(xaCon2);
    }

    public void testCloseLogicalConnection() throws Exception {
        XAConnectionImpl xaCon = _pool.requestXAConnection();
        assertEquals("1", 1, _pool.getActviePoolSize());
        assertEquals("2", 0, _pool.getPoolSize());
        xaCon.getConnection().close();
        assertEquals("3", 0, _pool.getActviePoolSize());
        assertEquals("4", 1, _pool.getPoolSize());
    }

    public void testCloseXAConnection() throws Exception {
        XAConnectionImpl xaCon = _pool.requestXAConnection();
        xaCon.close();
        assertEquals("1", 0, _pool.getActviePoolSize());
        assertEquals("2", 0, _pool.getPoolSize());
    }

    public void testXAResource() throws Exception {
        XAConnectionImpl xaCon = _pool.requestXAConnection();
        TransactionManagerImpl.getInstance().begin();
        SQLXAResource xaRes = (SQLXAResource) xaCon.getXAResource();
        assertEquals("1", SQLXAResource.RS_ACTIVE, xaRes.getStatus());
        xaCon.getConnection().close();
        assertEquals("2", SQLXAResource.RS_ACTIVE, xaRes.getStatus());
        TransactionManagerImpl.getInstance().commit();
        assertEquals("3", SQLXAResource.RS_NONE, xaRes.getStatus());
    }

    public void testTimeout() throws Exception {
        XAConnectionImpl xaCon = _pool.requestXAConnection();
        _pool.returnXAConnection(xaCon);
        Thread.sleep(10000);
        assertEquals("1", 0, _pool.getPoolSize());
    }
    
    public void testCommit() throws Exception {
    	TransactionManagerImpl.getInstance().begin();
        XAConnectionImpl xaCon = _pool.requestXAConnection();
        Connection con = xaCon.getConnection();
        con.close();
        TransactionManagerImpl.getInstance().commit();
        assertEquals("1", 1, _pool.getPoolSize());
    }
    
    public void testTransaction() throws Exception {
    	TransactionManagerImpl.getInstance().begin();
        XAConnectionImpl xaCon = _pool.requestXAConnection();
        Connection con = xaCon.getConnection();
        con.close();
        XAConnectionImpl xaCon2 = _pool.requestXAConnection();
        Connection con2 = xaCon.getConnection();
        con2.close();
        TransactionManagerImpl.getInstance().commit();
        assertEquals("1", true, xaCon == xaCon2);
    }

    protected void setUp() throws Exception {
        Properties p = new Properties();
        p.setProperty("driverClassName", "oracle.jdbc.driver.OracleDriver");
        p.setProperty("URL", "jdbc:oracle:thin:@d1606:1521:ark");
        p.setProperty("user", "ark");
        p.setProperty("password", "ark");
        ConnectionPoolMetaData cpmd = new ConnectionPoolMetaData("oracle", "jdbc/oracle",
            "org.seasar.sql.XADataSourceImpl", 6, 1, p);
        _pool = new ConnectionPool(cpmd);
    }

    protected void tearDown() throws Exception {
        _pool.close();
    }

    public static Test suite ( ) {
        return new TestSuite(ConnectionPoolTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{ConnectionPoolTest.class.getName()});
    }
}