package test.org.seasar.util;

import junit.framework.*;
import java.util.*;
import org.seasar.util.*;

public class StructTest extends TestCase {

    private Struct _struct;

    public StructTest(String name) {
        super(name);
    }

    public void testContainsKey() throws Exception {
        assertTrue("1", _struct.containsKey("ONE"));
		assertTrue("2", _struct.containsKey("one"));
        assertTrue("3", !_struct.containsKey("onex"));
    }

    public void testGet() throws Exception {
        assertEquals("1", "1", _struct.get("ONE"));
		assertEquals("2", "1", _struct.get("One"));
        assertEquals("3", null, _struct.get("hoge"));
    }

    public void testPut() throws Exception {
        assertEquals("1", "1", _struct.put("One", "11"));
        assertEquals("2", "11", _struct.get("one"));
    }

    public void testRemove() throws Exception {
        assertEquals("1", "1", _struct.remove("ONE"));
        assertEquals("2", 1, _struct.size());
        assertEquals("3", null, _struct.remove("dummy"));
    }

    public void testPutAll() throws Exception {
        Map m = new HashMap();
        m.put("three", "3");
        m.put("four", "4");
        _struct.putAll(m);
        assertEquals("1", "3", _struct.get("THREE"));
        assertEquals("2", "4", _struct.get("FOUR"));
        assertEquals("3", 4, _struct.size());
    }

    public void testPerformance() throws Exception {
    	for (int j = 0; j < 3; ++j) {
    	
        int num = 100000;
        Map hmap = new HashMap();
        Map struct = new Struct();

        long start = System.currentTimeMillis();
        for (int i = 0; i < num; i++) {
            hmap.put("a" + String.valueOf(i), null);
        }
        System.out.println("HashMap.put:" + (System.currentTimeMillis() - start));

		start = System.currentTimeMillis();
        for (int i = 0; i < num; i++) {
            struct.put("a" + String.valueOf(i), null);
        }
        System.out.println("Struct.put:" + (System.currentTimeMillis() - start));

        start = System.currentTimeMillis();
        for (int i = 0; i < num; i++) {
            hmap.get("a" + String.valueOf(i));
        }
        System.out.println("HashMap.get:" + (System.currentTimeMillis() - start));
        
        start = System.currentTimeMillis();
        for (int i = 0; i < num; i++) {
            struct.get("a" + String.valueOf(i));
        }
        System.out.println("Struct.get:" + (System.currentTimeMillis() - start));
        
        start = System.currentTimeMillis();
        for (int i = 0; i < num; i++) {
            hmap.remove("a" + String.valueOf(i));
        }
        System.out.println("HashMap.remove:" + (System.currentTimeMillis() - start));

        start = System.currentTimeMillis();
        for (int i = 0; i < num; i++) {
            struct.remove("a" + String.valueOf(i));
        }
        System.out.println("Struct.remove:" + (System.currentTimeMillis() - start));
        
    	}

    }


    protected void setUp() throws Exception {
        _struct = new Struct();
        _struct.put("one", "1");
        _struct.put("two", "2");
    }

    protected void tearDown() throws Exception {
        _struct = null;
    }

    public static Test suite() {
        return new TestSuite(StructTest.class);
    }

    public static void main(String[] args) {
        junit.textui.TestRunner.main(new String[]{StructTest.class.getName()});
    }
}
