// Copyright 2002 Macromedia, Inc. and its licensors.  All Rights Reserved.
//
// Use and/or redistribution of this file, in whole or in part, is subject
// to the Macromedia Sample Files License, which was distributed with this file.
//
//
/*

TabController class


	The purpose of this class is to group tab constants so that they can be
	used throughout the movie.  It also implements a mechanism for adding
	and removing groups of movie clips to the tab order.


	The class is meant to be used as singleton- it shouldn't be instantiated
	and all access should go through the _global.TabController .

	This file is a pure ActionScript object that takes movie clip instances.

	#include info for this file:

			FLA:				main.fla

			Layer:				Actions : Class Definitions

			Frame:				1

			Library Symbol:		N/A

			Library Path:		N/A


*/
//
function TabConstants () {
}

TabConstants.prototype.CategoryUIStartTab = 1;
TabConstants.prototype.ItemsUIStartTab = 20;
TabConstants.prototype.HistoryUIStartTab = 40;
TabConstants.prototype.SearchUIStartTab = 60;
TabConstants.prototype.CartUIStartTab = 80;
TabConstants.prototype.CheckoutUIStartTab = 100;
TabConstants.prototype.TopNavUIStartTab = 120;
TabConstants.prototype.ProfileUIStartTab = 200;
TabConstants.prototype.BillingFieldsUIStartTab= 250;
TabConstants.prototype.ShippingFieldsUIStartTab = 300;
TabConstants.prototype.ShippingMethodsUIStartTab = 350;
TabConstants.prototype.PaymentMethodsUIStartTab = 400;
TabConstants.prototype.TabConstants_GID = 0;

//----------------------------------------------------------------------
//TabController 
//----------------------------------------------------------------------
function TabController () {
	this.groups = new Object();
	this.activeTabs = new Object();
}

_global.tabController = new TabController();

//----------------------------------------------------------------------
// setTab
//
// Adds or removes a movie clip in the tab order.  Movie clips are added
// as part of groups.  If a movie clip isn't part of a group, just use
// movieClip._target for the group name.
//----------------------------------------------------------------------
TabController.prototype.setTab = function(group, mc, newTabIndex) {
	if(this.groups[group] == undefined) {
		this.groups[group] = new Object();
	}
	if(newTabIndex != undefined) {
		this.activeTabs[mc._target] = newTabIndex;
		this.groups[group][mc._target] = newTabIndex;
	}
	else {
		if(this.groups[group][mc._target] != undefined) {
			this.activeTabs[mc._target] = undefined;
			delete this.activeTabs[mc._target];
			this.groups[group][mc._target] = undefined;
			delete this.groups[group][mc._target];
		}
	}
	mc.tabIndex = newTabIndex;
}

//----------------------------------------------------------------------
// resetTabs
//
// Can be called with 0 or more arguments.
//
// If 1 or more args, the args are the groups of tabs you want
// reset, otherwise resets all tabs.
//----------------------------------------------------------------------
TabController.prototype.resetTabs = function() {
	this.toggleTabs(arguments.join(","), false);
}

//----------------------------------------------------------------------
// restoreTabs
//
// Can be called with 0 or more arguments.
//
// If 1 or more args, the args are the groups of tabs you want
// restored, otherwise restores all tabs.
//----------------------------------------------------------------------
TabController.prototype.restoreTabs = function() {
	this.toggleTabs(arguments.join(","), true);
}

//----------------------------------------------------------------------
// getActiveTabs
// 
// 	Returns an associative array.  Keys are movie clip targets, values
// 	are tab indices.
//----------------------------------------------------------------------
TabController.prototype.getActiveTabs = function() {
	return this.activeTabs;
}

//----------------------------------------------------------------------
// setActiveTabs
// 
// 	Sets the active tabs, disables all the currrently active tabs.
//
// 	The tabs argument is an associative array, the keys are movieclip
// 	targets and the values are the tab indices.
//
//
// 	Returns old activeTabs.
//----------------------------------------------------------------------
TabController.prototype.setActiveTabs = function(tabs) {
	var mcTarget;
	for(mcTarget in this.activeTabs) {
		eval(mcTarget).tabIndex = undefined;
	}
	var oldtabs = this.activeTabs;
	this.activeTabs = tabs;
	for(mcTarget in this.activeTabs) {
		eval(mcTarget).tabIndex = this.activeTabs[mcTarget];
	}
	return oldtabs;
}

//----------------------------------------------------------------------
// toggleTabs
//
// 	An internal function that walks through a list of tab groups and
// 	calls toggleGroupTabs on each group in the list.
//----------------------------------------------------------------------
TabController.prototype.toggleTabs = function(groupList, toggleOn) {
	var l = groupList.length;
	if(l > 0) {
		groupList = groupList.split(",");
		l = groupList.length;
	}
	if(l > 0) {
		var i;
		for(i = 0; i < l; ++i) {
			if(this.groups[groupList[i]] != undefined) {
				this.toggleGroupTabs(groupList[i], toggleOn);
			}
		}
	}
	else {
		var group;
		for(group in this.groups) {
			this.toggleGroupTabs(group, toggleOn);
		}
	}
}

//----------------------------------------------------------------------
// toggleGroupTabs
//
// An internal function that toggles the tab indices of all the movie
// clips in a group.
//----------------------------------------------------------------------
TabController.prototype.toggleGroupTabs = function(group, toggleOn) {
	var mcTarget;
	for(mcTarget in this.groups[group]) {
		eval(mcTarget).tabIndex = toggleOn ? this.groups[group][mcTarget] : undefined;
		if(toggleOn) { 
			this.activeTabs[mcTarget] = this.groups[group][mcTarget];
		}
		else {
			this.activeTabs[mcTarget] = undefined;
			delete this.activeTabs[mcTarget];
		}
	}
}
//Authors: Brian Kruse (bkruse), Buck Bito (bbito)
