//
// Copyright 2002 Macromedia, Inc. and its licensors.  All rights reserved.
//	
// Use and/or redistribution of this file, in whole or in part, is subject to the
// Macromedia Sample Files License, which was distributed with this file.
//
// Credit Card Validation Functions (shared between client and server).
//
 
ccTypes = ["Diners Club", "American Express", "JCB", "Carte Blache", "Visa", "MasterCard", "Australian BankCard", "Discover/Novus"];

// Return the array of credit card types
function getCreditCardTypes() {
	return ccTypes;
}

// validate a credit card number
function validateCreditCard(str, cardType) {

	// Strip non-digit characters
	str = stripNonDigits(str);

	// Determine the card type that is indicated by the first four digits
	// of the supplied number, and take note of what the number length
	// should actually be based on the range and card type.
	var prefix = str.substr(0, 4);

	var diners1 = ["Diners Club", 3000, 3059, [14]];
	var diners2 = ["Diners Club", 3600, 3699, [14]];
	var diners3 = ["Diners Club", 3800, 3889, [14]];
	var amex1 = ["American Express", 3400, 3499, [15]];
	var amex2 = ["American Express", 3700, 3799, [15]];
	var jcb = ["JCB", 3528, 3589, [16]];
	var carte = ["Carte Blache", 3890, 3899, [14]];
	var visa = ["Visa", 4000, 4999, [16,14]];
	var mastr = ["MasterCard", 5100, 5599, [16]];
	var austr = ["Australian BankCard", 5610, 5610, [16]];
	var disc = ["Discover/Novus", 6011, 6011, [16]];
	var accepted = [diners1, diners2, diners3, amex1, amex2, jcb, carte, visa, mastr, austr, disc];
	var goodSoFar = false;
	var derivedCardType;

	debugBreak("checking cc#");
	for (var i = 0; i < accepted.length; i++) {

		if ((prefix >= accepted[i][1]) && (prefix <= accepted[i][2])) {

			// Set the card type derived from the prefix
			derivedCardType = accepted[i][0];

			// If the user indicated and derived card types don't match,
			// break out, resulting in setting error message and returning.
			if ( (cardType != derivedCardType) ) {
				break;
			}
									   
			// Verify the required length
			for (var j = 0; (j < accepted[i][3].length); j++) {

				if (str.length == accepted[i][3][j]) {

					// Good so far, continue validation.
					goodSoFar = true;
					break;
				}
			}

			// The prefix has matched and we either succeeded or failed to
			// match the correct number length. Either way, break out of the
			// outer loop and let the value of goodSoFar guide us.
			break;
		}
	}

	// If we're not good so far, then the prefix was not matched against
	// a supported card type or the prefix matched but the length was invalid.
	// If the numer doesn't pass the checksum and return false.
	if ( (!goodSoFar) ||
		  (!validCardChecksum(str)) ) {
		return false;
	}

	// The card number appears valid - return true.
	return true;
}

// If supplied number string passes checksum, return true; otherwise return false.
function validCardChecksum(str) {
	var checkSum = new Number(0);
	var digit = new Number(0);
	var i = 0;

	// If the string is an even number of digits, add the even digits to the checksum.
	// If the string is an odd number of digits, add the odd digits to the checksum.
	for (i = 1 - (str.length % 2); i < str.length; i += 2) {
		checkSum += Number(str.substr(i, 1));
	}

	// Working with the odd digits in an even length string and the even
	// digits in an odd length string, multiply these digits by two and
	// add the digit or the digit less nine to the checksum.
	for (i = (str.length % 2); i < str.length; i += 2) {
		digit = Number(str.substr(i, 1)) * 2;
		if (digit < 10) {
			checkSum += digit;
		} else {
			checkSum += (digit - 9);
		}
	}

	// If the checksum is divisible by ten, return true; otherwise return false.
	return (checkSum % 10 == 0);
}

/******
	'LIBRARY' style functions for the validation
******/

// stripNonDigits returns no more than 16 digits from the supplied string
function stripNonDigits(str) {
	newString = new String("");
	var charString;
	for ( var i = 0; i < str.length; i++ ) {
		charString = str.charAt(i);
		if ( this.isDigit(charString) ) {
			newString = newString.concat(charString);
		}
	}
	return newString.substr(0, 16);
}

// stripSpace() removes all occurrences of white space from a string.
// stripSpace() returns a NEW String object. The supplied String is unmodified.
function stripSpace(s) {
	newString = new String("");
	var charString;
	for (var i = 0; i < s.length; i++) {
		charString = s.charAt(i);
		if ( !this.isWhiteSpace(charString ) ) {
			newString = newString.concat(charString);
		}
	}
	return newString;
}

// trim() removes leading and trailing spaces from a string
// If the supplied string is non-zero length, a NEW string is
// returned and the original string is unmodified.
function trim(s) {
	if ( s.length == 0 ) {
		return "";
	}
	
	var start = 0;
	while ( this.isWhiteSpace(s.charAt(start)) )
	{
		start++;
	}

	var end = s.length - 1;
	while ( this.isWhiteSpace(s.charAt(end)) )
	{
		end--;
	}
	
	return s.substr(start, (end - start + 1));
}

// isWhiteSpace returns true if the supplied single character string is
// considered white space. Space is \u0020, tab is \u0009.
function isWhiteSpace(cS) {
	if ( (cS == "\u0020") || (cS == "\u0009") ) {
		return true;
	}
	return false;
}

// isDigit returns true if the supplied single character string is
// a digit from 0 (\u0030) thru 9 (\u0039).
function isDigit(d) {
	if ( (d >= "\u0030") && (d <= "\u0039") ) {
		return true;
	}
	return false;
}

// isDash returns true if the supplied single character string is
// the dash ('-') character (\u002d)
function isDash(d) {
	if ( (d == "\u002d") ) {
		return true;
	}
	return false;
}
