// Copyright 2002 Macromedia, Inc. and its licensors.  All Rights Reserved.
//
// Use and/or redistribution of this file, in whole or in part, is subject
// to the Macromedia Sample Files License, which was distributed with this file.
//
#initclip 2
//
//
/*
//
CartUI class

	The CartUI class encapsulates all UI behavior pertaining to the shopping cart.

	This is meant to be used as a singleton: i.e. It's not meant to be
	instantiated directly and all access should go through the _global.cartWidget_mc
	object.

	This file is associated with a library movie clip symbol.

	#include info for this file:

			FLA:				main.fla

			Layer:				Actions : Class

			Frame:				1

			Library Symbol:		cartWidget_mc

			Library Path:		widgetGroup/cartWidget/cartWidget_mc
//
*/
//

//----------------------------------------------------------------------
//CartUI
//----------------------------------------------------------------------
function CartUI() {
	_global.cartWidget_mc = this;
	this.isInCheckout = false;
}

// associate the CartUI class with the authortime cartWidget_mc instance
Object.registerClass("CartSymbol", CartUI);


CartUI.prototype = new MovieClip();

//----------------------------------------------------------------------
// init
//----------------------------------------------------------------------
CartUI.prototype.init = function(tabController, strings, cart) {
	this.tabController = tabController;
	this.tabCt = TabConstants.prototype.CartUIStartTab;
	this.strings = strings;
	this.cart = cart;
	this.cartSubtotalLabel_txt.text = this.strings.CART_SUBTOTAL_LBL_str;
	this.cartSubtotal_txt.text = _global.formatForCurrency(0);
	this.openContent_mc.productName_txt.text = this.strings.PRODUCT_LBL_str;
	this.openContent_mc.qtyOrdered_txt.text = this.strings.QTY_LBL_str;
	this.openContent_mc.itemPrice_txt.text = this.strings.PRICE_LBL_str;
	this.itemsInCartLabel_txt.text = this.strings.ITEMS_IN_CART_LBL_str;
	this.itemsInCart_txt.text = "0";
	this.openContent_mc.cartCheckout_ib.setChangeHandler("checkoutBtnClick", this);
	_global.sizeAndFormatIconBtn(this.openContent_mc.cartCheckout_ib, strings.CART_CHECKOUT_BTN_LBL_str, _global.formIconBtnFormat, true);
	this.openContent_mc.cartCheckout_ib._visible = false;
	this.openContent_mc.cartRemoveItem_ib.setChangeHandler("removeCartItem", this);
	_global.sizeAndFormatIconBtn(this.openContent_mc.cartRemoveItem_ib, strings.CART_REMOVE_BTN_LBL_str, _global.formIconBtnFormat);
	this.openContent_mc.cartRemoveItem_ib._visible = false;
	this.openContent_mc.cart_lb.controller = this;
	this.openContent_mc.cart_lb.tabChildren = true;
	this.openContent_mc.cart_lb.setItemSymbol("FPCCartListItemSymbol");
	this.openContent_mc.cart_lb.measureItmHgt();
	this.openContent_mc.cart_lb.setRowCount(5);
	this.openContent_mc.cart_lb.orig_cart_lb_myonkeydown = this.openContent_mc.cart_lb.myOnKeyDown;
	this.openContent_mc.cart_lb.myOnKeyDown = function() {
		if(Key.isDown(Key.DELETEKEY)) {
			this.controller.removeCartItemServer();
		}
		else {
			this.orig_cart_lb_myonkeydown();
		}
	}
	_global.sizeAndFormatListBox(this.openContent_mc.cart_lb, 5);
	this.openContent_mc.cart_lb.setChangeHandler("cartItemSelectionChanged", this);

	this.tabController.setTab("CartUI", this.headBG_mc, this.tabCt++);
	this.tabController.setTab("CartUI", this.openContent_mc.cart_lb, this.tabCt++);
	this.spinButtonTabIndex = this.tabCt++;
	this.tabController.setTab("CartUI", this.openContent_mc.cartRemoveItem_ib, this.tabCt++);
	this.tabController.setTab("CartUI", this.openContent_mc.cartCheckout_ib, this.tabCt++);
	this.tabController.resetTabs("CartUI"); //Disable tabs on hidden elements for init.
	// Re-enable widget button tab only.
	this.tabController.setTab("CartUI", this.headBG_mc, TabConstants.prototype.CartUIStartTab);

	this.resetTotalCost();
}

CartUI.prototype.startListening = function() {
	seasar.event.Broadcaster.addEventListener("addCartItem", this);
	seasar.event.Broadcaster.addEventListener("doCheckout", this);
	seasar.event.Broadcaster.addEventListener("continueShopping", this);
	seasar.event.Broadcaster.addEventListener("setShippingCharge", this);
	seasar.event.Broadcaster.addEventListener("applyDiscount", this);
}

CartUI.prototype.addCartItemPerformed= function(item){
	this.addItem(item);
	if(!this.isOpen) {
		this.headBG_mc.onPress();
	}
	this.updateCartTotal();
}

CartUI.prototype.doCheckoutPerformed= function(data){
	_global.sizeAndFormatIconBtn(this.openContent_mc.cartCheckout_ib, this.strings.CART_CONTINUE_BTN_LBL_str, _global.formIconBtnFormat, true);
	this.isInCheckout = true;
}

CartUI.prototype.continueShoppingPerformed= function(data){
	_global.sizeAndFormatIconBtn(this.openContent_mc.cartCheckout_ib, this.strings.CART_CHECKOUT_BTN_LBL_str, _global.formIconBtnFormat, true);
	this.isInCheckout = false;
	if (data.needNewCart) {
		this.openContent_mc.cart_lb.removeAll();
		this.cartSubtotal_txt.text = _global.formatForCurrency(0);
		this.itemsInCart_txt.text = "0";
		this.openContent_mc.cartRemoveItem_ib._visible = false;
		this.openContent_mc.cartCheckout_ib._visible = false;
		this.resetTotalCost();
	}
}

CartUI.prototype.setShippingChargePerformed = function(data){
	this.shipCost = data;
	this.updateTotalCost();
}

CartUI.prototype.applyDiscountPerformed = function(data){
	this.discount = data;
	this.updateTotalCost();
}

CartUI.prototype.itemQtySpinBtnChanged = function(spn) {
	spn.itm["ITEMQUANTITY"] = spn.getValue();
	this.updateCartTotal();
}

CartUI.prototype.addItem = function(item) {
	var index = this.findItemOIDIndex(item["ITEMOID"]);
	if (index == -1){
		item["ITEMQUANTITY"] = 1;
		this.openContent_mc.cart_lb.addItemAt(0, item["NAME"], item);
		this.openContent_mc.cart_lb.setSelectedIndex(0);
		this.openContent_mc.cart_lb.setScrollPosition(0);
	} else {
		var currItem = this.openContent_mc.cart_lb.getItemAt(index);
		if (currItem.data["ITEMQUANTITY"] < currItem.data["QUANTITY"]) {
			currItem.data["ITEMQUANTITY"]+=1;
			this.openContent_mc.cart_lb.setSelectedIndex(index);
			this.openContent_mc.cart_lb.setScrollPosition(index);
		} else {
			this.showQtyExceededError(currItem.data["QUANTITY"],
					"focus", _global.focuser.setFocusee(this.openContent_mc.cart_lb));
		}
	}
}

CartUI.prototype.showQtyExceededError = function(qtyAvailable, callback, object) {
	var msg = _global.appStrings.EXCEEDS_AVAILABLE_MB_MSG_str;
	msg += newline + _global.appStrings.QTY_AVAILABLE_LBL_str + " " + qtyAvailable;
	var title = _global.appStrings.EXCEEDS_AVAILABLE_MB_TTL_str;
	_global.warningBox(title, msg, callback, object);
}

CartUI.prototype.findItemOIDIndex = function(itemOID) {
	var count = this.openContent_mc.cart_lb.getLength();
	for (var i = 0; i < count; ++i){
		var currItm = this.openContent_mc.cart_lb.getItemAt(i);
		if (currItm.data["ITEMOID"] == itemOID){
			return i;
		}
	}
	return -1;
}

CartUI.prototype.removeCartItem = function() {
	var index = this.openContent_mc.cart_lb.getSelectedIndex();
	if (index >= 0) {
		this.openContent_mc.cart_lb.removeItemAt(index);
		this.updateCartTotal();
		var count = this.openContent_mc.cart_lb.getLength();
		this.openContent_mc.cartRemoveItem_ib._visible =  count > 0;
		if(!this.openContent_mc.cartRemoveItem_ib._visible && this.isInCheckout) {
			this.leaveCheckout();
		}
		if(this.isOpen && count == 0) {
			this.headBG_mc.onPress();
		}
	}
}

CartUI.prototype.updateCartTotal = function() {
	var count = this.openContent_mc.cart_lb.getLength();
	this.itemsInCart_txt.text = count
	this.openContent_mc.cartCheckout_ib._visible = count > 0;
	var total = 0;
	for (var i = 0; i < count; ++i) {
		var data = this.openContent_mc.cart_lb.getItemAt(i).data;
		total += data.LISTPRICE * data.ITEMQUANTITY;
	}
	this.cartSubtotal_txt.text = _global.formatForCurrency(total);
	this.subTotal = total;
	this.updateTotalCost();
}

CartUI.prototype.cartItemSelectionChanged = function() {
	this.openContent_mc.cartRemoveItem_ib._visible = true;
}

CartUI.prototype.checkoutBtnClick = function() {
	if (!this.isInCheckout) {
		this.doCheckout();
	} else {
		this.leaveCheckout();
	}
}

CartUI.prototype.doCheckout = function() {
	this.cart.doCheckout(this);
}

CartUI.prototype.leaveCheckout = function() {
	this.cart.continueShopping(false);
}

CartUI.prototype.toggleWidget = function(isOpening) {
	this.isOpen = isOpening;
	if(isOpening){
		this.tabController.restoreTabs("CartUI");
	}
	else{
		this.tabController.resetTabs("CartUI");
		this.tabController.setTab("CartUI", this.headBG_mc, TabConstants.prototype.CartUIStartTab);
	}
}

CartUI.prototype.toggleForCheckout = function(forCheckout) {
	this.widgetIconButtonBG_mc._visible = !forCheckout;
	this.headBG_mc.enabled = !forCheckout;
	this.tabController.setTab("CartUI", this.headBG_mc, 
			forCheckout ? undefined : TabConstants.prototype.CartUIStartTab);
	if(forCheckout){
		this.openContent_mc.gotoAndPlay("openForCheckout");
	}
	else{
		this.openContent_mc.gotoAndPlay("closeFromCheckout");
	}
}

CartUI.prototype.initCheckoutView = function(forCheckout) {
	this.openContent_mc.chargeSummary_mc.head_txt.text = this.strings.CHARGE_SUMMARY_HD_str;
	this.openContent_mc.chargeSummary_mc.hint_txt.text = this.strings.CHARGE_SUMMARY_HINT_str;
	this.openContent_mc.chargeSummary_mc.subtotalLabel_txt.text = this.strings.CHARGE_SUMMARY_SUBTOTAL_LBL_str;
	this.openContent_mc.chargeSummary_mc.discountLabel_txt.text = this.strings.CHARGE_SUMMARY_PROMOTIONS_LBL_str;
	this.openContent_mc.chargeSummary_mc.shippingLabel_txt.text = this.strings.CHARGE_SUMMARY_SHIPPING_LBL_str;
	this.openContent_mc.chargeSummary_mc.taxLabel_txt.text = this.strings.CHARGE_SUMMARY_TAX_LBL_str;
	this.openContent_mc.chargeSummary_mc.grandTotalLabel_txt.text = this.strings.CHARGE_SUMMARY_GRAND_TOTAL_LBL_str;
	this.updateChargeSummaryData();

}

CartUI.prototype.resetTotalCost = function() {
	this.subTotal = 0;
	if (this.shipCost == null) {
		this.shipCost = 0;
	}
	this.discount = 0;
	this.tax = 0;
	this.total = 0;
}

CartUI.prototype.updateTotalCost = function() {
	this.total = Number(this.subTotal) - Number(this.discount) + Number(this.shipCost) + Number(this.tax);
	this.cart.updateTotalCost(this.total);
	this.updateChargeSummaryData();
}

//----------------------------------------------------------------------
// updateChargeSummaryData
//----------------------------------------------------------------------
CartUI.prototype.updateChargeSummaryData = function()
{
	this.openContent_mc.chargeSummary_mc.subtotal_txt.text = _global.formatForCurrency(this.subTotal);
	this.openContent_mc.chargeSummary_mc.discount_txt.text = _global.formatForCurrency(this.discount);
	this.openContent_mc.chargeSummary_mc.shipping_txt.text = _global.formatForCurrency(this.shipCost);
	this.openContent_mc.chargeSummary_mc.tax_txt.text  = _global.formatForCurrency(this.tax);
	this.openContent_mc.chargeSummary_mc.grandTotal_txt.text  = _global.formatForCurrency(this.total);
}

#endinitclip
//Authors: Brian Kruse (bkruse), Buck Bito (bbito)
