// Copyright 2002 Macromedia, Inc. and its licensors.  All Rights Reserved.

function CategoryUI() {
	this.catWidgetCollection = new Object();
	this.catAnimBusy = true;
	this.currCategoryWidget = null;
	this.productsDone = true;
	this.productsError = false;
	this.pendingCatOID = -1;
	this.productsVisited = false;
	this.enabled = false;
	this.currentProdOID = -1;
	this.currentCatOID = -1;
}

_global.categoryUI = new CategoryUI();

//----------------------------------------------------------------------
// init
//----------------------------------------------------------------------
CategoryUI.prototype.init = function(tabController, catalog, catHolder_mc, prodHolder_mc) {
	this.tabController = tabController;
	this.catalog = catalog;
	this.categoryHolder_mc = catHolder_mc;
	this.productHolder_mc = prodHolder_mc;
	this.enabled = true;
	this.initProdLB();
}

//----------------------------------------------------------------------
// setEnabled
//----------------------------------------------------------------------
CategoryUI.prototype.setEnabled = function(enabled) {
	var currCatOid;
	for(currCatOid in this.catWidgetCollection) {
		var catBtn = this.catWidgetCollection[currCatOid].cat_mc;
		catBtn.enabled = enabled;
	}
	this.enabled = enabled;
	this.productHolder_mc.products_lb.setEnabled(enabled);
}


//----------------------------------------------------------------------
// startListening
//----------------------------------------------------------------------
CategoryUI.prototype.startListening = function() {
	seasar.event.Broadcaster.addEventListener("getCategories", this);
	seasar.event.Broadcaster.addEventListener("getProducts", this);
	seasar.event.Broadcaster.addEventListener("getProductsStatus", this);
	seasar.event.Broadcaster.addEventListener("getItems", this);
	seasar.event.Broadcaster.addEventListener("changeSelectedProduct", this);
}

CategoryUI.prototype.getCategoriesPerformed = function(data) {
	this.createAll(data);
}

CategoryUI.prototype.getProductsPerformed = function(rs) {
	if (rs.getLength() > 0) {
		var id = rs.getItemAt(0)["CATEGORYOID"];
		if (id == this.pendingCatOID) {
			this.currentCatOID = id;
			this.pendingCatOID = -1;
			this.productsDone = true;
			this.productsError = false;
			this.catWidgetCollection[id].productsRS = rs;
		}
	}
}

CategoryUI.prototype.getProductsStatusPerformed = function(exception) {
	this.pendingCatOID = -1;
	this.productsDone = true;
	this.productsError = true;
}

CategoryUI.prototype.getItemsPerformed = function(result) {
	this.stopProdAnimation = true;
}

CategoryUI.prototype.changeSelectedProductPerformed = function(data) {
	this.focusOnProdLB = false;
	this.changeSelectedProduct(data.catOID, data.prodOID);
}

//----------------------------------------------------------------------
// reset
//----------------------------------------------------------------------
CategoryUI.prototype.reset = function() {
	this.currCategoryWidget.cat_mc._visible = true;
	this.productsVisited = false;
	this.currCategoryWidget = null;
	this.productHolder_mc._visible = false;
	this.stopProdAnimation = false;
	this.pendingCatOID = -1;
	this.pendingProdRec = undefined;
	this.pendingSelProd = undefined;
	this.focusOnProdLB = false;
	this.catAnimBusy = false;
	this.prodAnimBusy = false;
	this.enabled = true;
	this.currentProdOID = -1;
	this.currentCatOID = -1;
}

//----------------------------------------------------------------------
// createAll
//----------------------------------------------------------------------
CategoryUI.prototype.createAll = function(recordset) {
	var l = recordSet.getLength();
	for (i=0; i<l; i++) {
		var rs = recordSet.getItemAt(i);
		var catWidget =new CategoryWidget(i, rs);
		catWidget.controller = this;
		this.catWidgetCollection[rs["CATEGORYOID"]] = catWidget;
		catWidget.init();
	}
	this.catAnimBusy = false;
}

//----------------------------------------------------------------------
// changeSelectedProduct
//
// 	This function starts the animation that plays when the product 
// 	changes.
//----------------------------------------------------------------------
CategoryUI.prototype.changeSelectedProduct = function (catOID, newProdOID, pressed_mc, currCatWidget) {
	if((this.currentCatOID != catOID || this.currentProdOID != newProdOID) &&
			(this.pendingSelProd == undefined ||
			 catOID != this.pendingSelProd.catOID || newProdOID != this.pendingSelProd.prodOID)) {
		// <TRICKY> Prevent the ui from getting overwhelmed by not requesting
		// new prod info until the category animation stops.  Remember last requested
		// category/product so we can fire off more recent request when animation finishes.
		if(!this.catAnimBusy) {
			this.productHolder_mc.products_lb.removeAll();
			this.catAnimBusy = true;
			this.pendingCatOID = catOID;
			this.productsDone = false;
			this.productsError = false;
			if(pressed_mc == null) {
				pressed_mc = this.categoryHolder_mc["catNav"+catOID];
			}
			else {
				// A category button press fired this off, so 
				// we want to focus on prodLB when we are done.
				this.focusOnProdLB = true;
			}
			if(currCatWidget == null) {
				currCatWidget = this.catWidgetCollection[catOID];
			}
			var currCatOid;
			for(currCatOid in this.catWidgetCollection) {
				var curr_mc = this.catWidgetCollection[currCatOid].cat_mc;
				if(!curr_mc._visible && curr_mc != pressed_mc){
					curr_mc._visible = true;
				}
			}
			currCatWidget.newProdOID = newProdOID;
			currCatWidget.productsRS = null;
			this.currCategoryWidget = currCatWidget;
			this.catalog.categoryChanged(catOID, currCatWidget.getName());
			currCatWidget.animateCategoryChange();
			this.catalog.getProducts(catOID);
		}
		else {
			this.pendingSelProd = { catOID : catOID, prodOID : newProdOID };
			this.pendingProdRec = undefined;
		}
		// </TRICKY>
	}
}

//----------------------------------------------------------------------
// prodLBChangeHandler
//----------------------------------------------------------------------
CategoryUI.prototype.prodLBChangeHandler = function(theProd_lb) {
	this.productsVisited = true;
	var curr_sel_prod = theProd_lb.getSelectedItem().data;
	var curr_sel_oid = curr_sel_prod["PRODUCTOID"]; 
	if(curr_sel_oid != undefined && (curr_sel_oid != this.currentProdOID &&
			(this.pendingSelProd == undefined || 
			 curr_sel_oid != this.pendingSelProd.getItemAt(0)["PRODUCTOID"]))) {
		// <TRICKY>: Prevent the ui from getting overwhelmed by not requesting
		// new prod info until the product animation stops.  Remember last requested
		// product so we can fire off a request when animation finishes
		// Note: if we've a pending change category request, that trumps the pending 
		// product request so we completely ignore this event if there's pending cat change
		// request.
		if(!this.prodAnimBusy) {
			this.prodAnimBusy = true;
			this.currentProdOID = curr_sel_oid;
			theProd_lb.currCatWidget.currProdOID = curr_sel_oid;
			this.animateProductChange(curr_sel_prod, theProd_lb.currCatWidget.getLabel(), 
					theProd_lb.currCatWidget.getColor());
			this.catalog.browseNewProduct(curr_sel_prod, theProd_lb.currCatWidget.getLabel(), 
					theProd_lb.currCatWidget.getName(), 
					theProd_lb.currCatWidget.getColor());
		}
		else if(this.pendingSelProd == undefined) {
			this.pendingProdRec= { record : curr_sel_prod,
									label : theProd_lb.currCatWidget.getLabel(),
									name : theProd_lb.currCatWidget.getName(),
									color : theProd_lb.currCatWidget.getColor() };
		}
		// </TRICKY>
	}
}

//----------------------------------------------------------------------
// animateProductChange
//
// 	This function initializes the product change animation and sets up 
// 	onEnterFrame event handler.
//----------------------------------------------------------------------
CategoryUI.prototype.animateProductChange = function(prodRS, label, color)
{
	var wiper_mc = this.productHolder_mc.productChangeWiper_mc;
	wiper_mc.counter = 1;
	wiper_mc._x = wiper_mc.base_x;
	wiper_mc._y = wiper_mc.base_y;
	wiper_mc._xscale = wiper_mc.base_xScale;
	wiper_mc._yscale = wiper_mc.base_yScale;
	wiper_mc.controller = this;
	wiper_mc.prodRS = prodRS;
	wiper_mc.label = label;
	wiper_mc.color = color;
	this.stopProdAnimation = false;
	wiper_mc.onEnterFrame = CategoryUI.prototype.doProductChangeAnimation;
}

//----------------------------------------------------------------------
// doProductChangeAnimation
//	
//	In function below: this = wiper_mc
// 
// 	While active, this function is called once per frame by the player.
//----------------------------------------------------------------------
CategoryUI.prototype.doProductChangeAnimation = function()
{
	if (this.counter <= this.steps) {
		this._x += this.xInc;
		this._y += this.yInc;
		this._xscale += this.xScaleInc;
		this._yscale += this.yScaleInc;
		this.counter++;
	}
	else if(this.controller.stopProdAnimation) {
		this.controller.prodAnimBusy = false;
		this.controller.catalog.notifyProductAnimationComplete(this.prodRS, this.label, this.color);
		delete this.onEnterFrame;
		this._x = this.base_x;
		this._y = this.base_y;
		this._xscale = this.base_xScale;
		this._yscale = this.base_yScale;
		if(this.controller.pendingProdRec != undefined) {
			this.controller.animateProductChange(this.controller.pendingProdRec.record, 
					this.controller.pendingProdRec.label, this.controller.pendingProdRec.color);
			this.controller.catalog.browseNewProduct(this.controller.pendingProdRec.record, 
					this.controller.pendingProdRec.label, this.controller.pendingProdRec.name, 
					this.controller.pendingProdRec.color);
			this.controller.pendingProdRec = undefined;
		}
	}
}

//----------------------------------------------------------------------
//
//
// CategoryWidget is a class that encapsulates the individual category buttons.
// It's meant to be a private class used only by the CategoryUI.
//
//----------------------------------------------------------------------

//----------------------------------------------------------------------
//CategoryWidget
//----------------------------------------------------------------------
function CategoryWidget(index, catRS) {
	this.index = index;
	this.categoryRS = catRS;
	this.productsRS = null;
}

//----------------------------------------------------------------------
// getName
//----------------------------------------------------------------------
CategoryWidget.prototype.getName = function() {
	return this.categoryRS["CATEGORYNAME"];
}

//----------------------------------------------------------------------
// getLabel
//----------------------------------------------------------------------
CategoryWidget.prototype.getLabel = function() {
	return this.categoryRS["CATEGORYDISPLAYNAME"];
}

//----------------------------------------------------------------------
// getColor
//----------------------------------------------------------------------
CategoryWidget.prototype.getColor = function() {
	return "0x"+this.categoryRS["COLOR"];
}

//----------------------------------------------------------------------
// init
//----------------------------------------------------------------------
CategoryWidget.prototype.init = function()
{
	var catOID = this.categoryRS["CATEGORYOID"];
	var label = this.categoryRS["CATEGORYDISPLAYNAME"];
	var catName = this.categoryRS["CATEGORYNAME"];
	var lecolor = this.getColor();


	var holder = this.controller.categoryHolder_mc;
	holder.attachMovie("catNav_btnBase_mc", "catNav"+catOID, this.index);
	this.cat_mc = holder["catNav"+catOID];
	this.cat_mc.attachMovie("catNavImage"+catName, "image", this.index);
	this.cat_mc.image.setMask(this.cat_mc.mask);
	this.cat_mc.attachMovie("catNavShape_mc", "colorShape", this.index+1);
	var catColor = new Color(this.cat_mc.colorShape);
	catColor.setRGB(lecolor);
	this.cat_mc.colorShape._alpha = 0;
	this.cat_mc.createTextField("label_txt", this.index+2, 5, 55, 75, 20);
	this.cat_mc.label_txt.text = label;
	this.cat_mc.label_txt.setTextFormat(_global.catNavLabel_fmt);
	this.cat_mc.label_txt.embedFonts = true;
	this.cat_mc.data = data;
	this.cat_mc._x = this.index*85;
	this.cat_mc.catOID = catOID;
	this.cat_mc.controller = this;
	this.controller.tabController.setTab("CategoryUI", this.cat_mc, 
			this.index + TabConstants.prototype.CategoryUIStartTab);
	this.cat_mc.onPress = CategoryWidget.prototype.categoryPressed;
}


//----------------------------------------------------------------------
// categoryPressed
//----------------------------------------------------------------------
CategoryWidget.prototype.categoryPressed = function() {
	var catUI = this.controller.controller;
	if(catUI.enabled) {
		catUI.changeSelectedProduct(this.catOID, null, this);
	}
}

//----------------------------------------------------------------------
// animateCategoryChange
//
// 	This initializes the category change animation and sets up the 
// 	onEnterFrame event handler.
//----------------------------------------------------------------------
CategoryWidget.prototype.animateCategoryChange = function()
{
	var point = new Object();
	point.x = this.controller.productHolder_mc._x;
	point.y = this.controller.productHolder_mc._y;
	
	this.cat_mc.x1 = this.cat_mc._x;
	this.cat_mc.y1 = this.cat_mc._y;

	this.cat_mc._parent.globalToLocal(point);
	var x2 = point.x;
	var y2 = point.y;
	this.cat_mc.steps = 5;
	var parentScaleMod = 1;
	if(this.cat_mc._parent._xscale != 100){
		parentScaleMod = 100/this.cat_mc._parent._xscale;
	}
	this.cat_mc.x1Scale = this.cat_mc._xscale;
	this.cat_mc.y1Scale = this.cat_mc._yscale;
	this.cat_mc.scaleInc = (230*parentScaleMod - this.cat_mc.x1Scale)/this.cat_mc.steps;
	this.cat_mc.xInc = (x2 - this.cat_mc.x1)/this.cat_mc.steps;
	this.cat_mc.yInc = (y2 - this.cat_mc.y1)/this.cat_mc.steps;
	this.cat_mc.counter = 1;
	
	
	this.cat_mc.onEnterFrame = CategoryWidget.prototype.doCatChangeAnimation;
}

//----------------------------------------------------------------------
// doCatChangeAnimation
//	
//	In function below: this = wiper_mc
// 
// 	While active, this function is called once per frame by the player.
//----------------------------------------------------------------------
CategoryWidget.prototype.doCatChangeAnimation = function () {
	if (this.counter <= this.steps) {
		this._x += this.xInc;
		this._y += this.yInc;
		this._xscale += this.scaleInc;
		this._yscale += this.scaleInc;
		this.colorShape._alpha = (100 / this.steps) * this.counter;
		this.counter++;
	}
	else{
		var catUI = this.controller.controller;
		if(catUI.productsDone) {
			catUI.catAnimBusy = false;
			if(this.controller.productsRS != null){
				if(this.controller.productsRS.getLength() > 0) {
					var catoid = this.controller.productsRS.getItemAt(0)["CATEGORYOID"];
					if(catoid == this.controller.categoryRS["CATEGORYOID"]) {
						catUI.productHolder_mc._visible = true;
						this.controller.drawProductLB();
					}
				}
			}

			delete this.onEnterFrame;
			this._visible = false;
			this._x = this.x1;
			this._y = this.y1;
			this._xscale = this.x1Scale;
			this._yscale = this.y1Scale;
			this.colorShape._alpha = 0;
			if(this.controller.productsRS == null){
				this._visible = true;
			}
			if(catUI.productsError) {
				catUI.productHolder_mc._visible = false;
			}
			else if(catUI.pendingSelProd) {
				catUI.changeSelectedProduct(catUI.pendingSelProd.catOID, catUI.pendingSelProd.prodOID);
				catUI.pendingSelProd = undefined;
			}
		}
	}
}

//----------------------------------------------------------------------
// initProdLB
//----------------------------------------------------------------------
CategoryUI.prototype.initProdLB = function() {
	var prodNavHolder = this.productHolder_mc;
	prodNavHolder._visible = false;
	// :TRICKY: "Magic" postioning numbers
	var prod_mcScale = 230;
	var label_txtX = 5;
	var label_txtY = 55;
	var label_txtWidth = 75;
	var label_txtHeight = 20;
	var wiper_mcCenterOffset = 7;
	var wiper_mcAnimationSteps = 5;
	var wiper_mcAlpha = 80;
	var prod_lbX = 8;
	var prod_lbY = 18;
	var prod_lbWidth = 162;
	// Product listBox height is set with setRowCount()
	var prod_lbRowCt = 7;
	var bezelYOffset = -1;
	var bezelHeightOffset = 1;
	// :END TRICKY: "Magic" postioning numbers
	var ct = 1;
	var wiper_mc = prodNavHolder.attachMovie("hairlineMainBG_mc", "productChangeWiper_mc", ct++);
	var prod_mc = prodNavHolder.attachMovie("catNav_btnBase_mc", "productNavBase", ct++);
	prod_mc._xscale = prod_mc._yscale = prod_mcScale;
	prod_mc.createTextField("label_txt", ct++, label_txtX, label_txtY, label_txtWidth, label_txtHeight);
	var itemUI_mc = itemBrowsing_mc;
	//:TRICKY: Differences in the corner radii require offset.
	wiper_mc.base_x = wiper_mc._x = wiper_mc.base_y = wiper_mc._y = wiper_mcCenterOffset;
	wiper_mc._alpha = wiper_mcAlpha;
	var point = new Object();
	point.x = itemUI_mc._x;
	point.y = itemUI_mc._y;
	wiper_mc.steps = wiper_mcAnimationSteps;
	wiper_mc._parent.globalToLocal(point);
	wiper_mc.x1 = point.x;
	wiper_mc.y1 = point.y;
	wiper_mc.xInc = (wiper_mc.x1 - wiper_mc.base_x) / wiper_mc.steps;
	wiper_mc.yInc = (wiper_mc.y1 - wiper_mc.base_y) / wiper_mc.steps;
	//:TRICKY: prod_mc dimensions include dropshadow, must scale to a fraction of that size.
	wiper_mc._xscale = wiper_mc.base_xScale = ((prod_mc._width * 0.85) / wiper_mc._width) * 100;
	wiper_mc._yscale = wiper_mc.base_yScale = ((prod_mc._height * 0.85) / wiper_mc._height) * 100;
	wiper_mc.xScaleInc = (100 - wiper_mc._xscale) / wiper_mc.steps;
	wiper_mc.yScaleInc = (100 - wiper_mc._yscale) / wiper_mc.steps;
	wiper_mc.counter = 1;
	
	var prod_lb = prodNavHolder.attachMovie("FListBoxSymbol", "products_lb", ct++);
	this.tabController.setTab("CategoryUI", 
			prod_lb, TabConstants.prototype.CategoryUIStartTab + 10);
	prod_lb.setChangeHandler("prodLBChangeHandler", this);
	_global.initStyles();
	prod_lb.setStyleProperty("textSelected", 0xFFFFFF);
	prod_lb.setStyleProperty("embedFonts", true);
	prod_lb.setAutoHideScrollBar(true);
	prod_lb._x = prod_lbX;
	prod_lb._y = prod_lbY;
	_global.sizeAndFormatListBox(prod_lb, prod_lbRowCt, ct++, prod_lbWidth);
}

//----------------------------------------------------------------------
// drawProductLB
//
// Change the product listbox to match the current category color.
//----------------------------------------------------------------------
CategoryWidget.prototype.drawProductLB = function() 
{
	var label = this.categoryRS["CATEGORYDISPLAYNAME"];
	var curr_catColor = this.getColor();
	var prodNavHolder = this.controller.productHolder_mc;
	prodNavHolder._visible = true;
	var prod_mc = prodNavHolder.productNavBase;
	var prod_lb = prodNavHolder.products_lb;
	prod_lb.currCatWidget = this;

	catColor = new Color(prod_mc.mask);
	catColor.setRGB(curr_catColor);
	prod_mc.label_txt.text = label;
	prod_mc.label_txt.setTextFormat(_global.catNavLabel_fmt);
	prod_mc.label_txt.embedFonts = true;
	
	prod_lb.setStyleProperty("background", curr_catColor);
	prod_lb.setStyleProperty("backgroundDisabled", curr_catColor);
	prod_lb.setStyleProperty("face", curr_catColor);
	prod_lb.setStyleProperty("scrollTrack", curr_catColor);
	prod_lb.setStyleProperty("selection", curr_catColor);
	prod_lb.setStyleProperty("selectionUnfocused", curr_catColor);
	prod_lb.setStyleProperty("selectionDisabled", curr_catColor);
	prod_lb.setStyleProperty("highlight", curr_catColor);
	prod_lb.setStyleProperty("highlightDisabled", curr_catColor);
	prod_lb.setStyleProperty("shadow", curr_catColor);
	var selectedProduct = _global.rsToComponent(prod_lb, this.productsRS, "NAME", "PRODUCTOID", this.newProdOID);

	if(selectedProduct != null || this.controller.productsVisited) {
		if(selectedProduct == null) {
			selectedProduct = 0;
		}
		prod_lb.setSelectedIndex(selectedProduct);
		prod_lb.setScrollPosition(selectedProduct);
	}
	if(this.controller.focusOnProdLB) {
		// TRICKY: The ListBox component has a clickFilter in place that causes 
		// the first click to be lost if we explicitly set focus on the list box.
		prod_lb.clickFilter = true;
		Selection.setFocus(prod_lb);
		// TRICKY: In order to retain a focus rectangle on the listbox, we need 
		// to override setSize function exactly once.  The default implementation
		// of setSize erases the focus rectangle.
		prod_lb.oldsetSize = prod_lb.setSize;
		prod_lb.setSize = function(w, h) { 
			this.oldsetSize(w,h); 
			this.drawFocusRect();
			this.setSize = this.oldsetSize;
		}
	}

}

//Authors: Brian Kruse (bkruse), Buck Bito (bbito)
