// Copyright 2002 Macromedia, Inc. and its licensors.  All Rights Reserved.
//
// Use and/or redistribution of this file, in whole or in part, is subject
// to the Macromedia Sample Files License, which was distributed with this file.
//
#initclip 
//
//
/*
//
PaymentMethodsUI class

	The PaymentMethodsUI class encapsulates all UI behavior of the PaymentMethods
	section of the checkout.

	This code is meant to initialize the section and provide uniform access
	to the PaymentMethods data object.

	This file is associated with a library movie clip symbol.

	#include info for this file:

			FLA:				main.fla

			Layer:				Actions : Class

			Frame:				1

			Library Symbol:		paymentFldsOpenContent_mc

			Library Path:		CheckoutWidget/paymentFlds/paymentFldsOpenContent_mc
//
*/
//

//----------------------------------------------------------------------
//PaymentMethodsUI
//
// As with all the CheckoutUI classes, this class encapsulates the 
// behaviour of the "open" state of this checkout widget.
//
// The "closed" state of this widget can be referenced via:
//
// 	this._parent.summaryContent_mc
//
//----------------------------------------------------------------------
function PaymentMethodsUI() {
}

// associate the PaymentMethodsUI class with the authortime paymentFldsOpenContent_mc instance
Object.registerClass("PaymentMethodsUISymbol", PaymentMethodsUI);

PaymentMethodsUI.prototype = new MovieClip();

//----------------------------------------------------------------------
// init
//----------------------------------------------------------------------
PaymentMethodsUI.prototype.init = function(tabController, firstTab, strings, checkout) {
	this.checkout = checkout;
	this.strings = strings;
	var tabCount = firstTab;
	tabController.setTab("PaymentMethodsUI", this.payMethod_cb, tabCount++);
	tabController.setTab("PaymentMethodsUI", this.expiryMonth_cb, tabCount++);
	tabController.setTab("PaymentMethodsUI", this.expiryYear_cb, tabCount++);
	tabController.setTab("PaymentMethodsUI", this.ccNumberFld_mc.input_txt, tabCount++);
	tabController.setTab("PaymentMethodsUI", this.submit_ib, tabCount++);
	
	this.hint_txt.text = strings.PAYMENT_METHODS_HINT_str;
	this.grandTotalLabel_txt.text = strings.CHARGE_SUMMARY_GRAND_TOTAL_LBL_str;
	this.grandTotal_txt.text = _global.formatForCurrency(0);

	var payMethod_array = checkout.cart.getCreditCards();
	var l = payMethod_array.length;
	for (i=0; i<l; i++){
		this.payMethod_cb.addItem(payMethod_array[i], payMethod_array[i]);
	}
	_global.sizeAndFormatCombo(this.payMethod_cb, 200, 16); // this method found in formats.as
	this.payMethodLabel_txt.text = strings.PAYMENT_METHOD_LBL_str;
	this.payMethodStatusIcon_mc.gotoAndStop("required");

	this.ccNumberFld_mc.label_txt.text = strings.CC_NUMBER_LBL_str;
	// NOTE: delete the next three lines and uncomment the validator below if you
	// wish to validate credit cards.
	this.ccNumberFld_mc.input_txt.text = "Not needed for demo";
	this.ccNumberFld_mc.input_txt.type = "dynamic";
	this.ccNumberFld_mc.input_txt.border = true;
	this.ccNumberFld_mc.statusIcon_mc.gotoAndStop("required");

	this.expiryLabel_txt.text = strings.CC_EXPIRATION_DATE_LBL_str;

	this.expiryMonthStatusIcon_mc.gotoAndStop("required");
	this.expiryMonth_cb.addItem(this.strings.EXP_MONTH_CHOOSE_str, "");
	var l = this.strings.MONTH_NUMS_array.length;
	for (i=0; i<l; i++){
		this.expiryMonth_cb.addItem(this.strings.MONTH_NUMS_array[i], i+1);
	}
	_global.sizeAndFormatCombo(this.expiryMonth_cb, 82, 13); // this method found in formats.as

	this.expiryYearStatusIcon_mc.gotoAndStop("required");
	this.expiryYear_cb.addItem(this.strings.EXP_YEAR_CHOOSE_str, "");
	var l = this.strings.EXP_YEARS_array.length;
	for (i=0; i<l; i++){
		this.expiryYear_cb.addItem(this.strings.EXP_YEARS_array[i], this.strings.EXP_YEARS_array[i]);
	}
	_global.sizeAndFormatCombo(this.expiryYear_cb, 82, 13); // this method found in formats.as

	_global.sizeAndFormatIconBtn(this.submit_ib,
			strings.CHECKOUT_SUBMIT_BTN_LBL_str, _global.formIconBtnFormat);
	this.submit_ib.controller = this;
	this.submit_ib.setChangeHandler("validateAndNotifyCheckout", this);

}

//----------------------------------------------------------------------
// copyToSummary
//
// 	This function is called after the widget has been validated and is
// 	collapsing.
//----------------------------------------------------------------------
PaymentMethodsUI.prototype.copyToSummary = function()
{
	var summary_txt = this._parent.summaryContent_mc.summary_txt;
	var ccNumber_str = this.ccNumberFld_mc.input_txt.text;
	var ccLen = ccNumber_str.length;
	var lastSpace = (ccNumber_str.lastIndexOf(" ") == -1 ) ? ccLen - 5 : ccNumber_str.lastIndexOf(" ");
	var clearNumbers_str = ccNumber_str.substr(lastSpace+1);
	var obscureCC_str = "";
	for (i=0; i <= lastSpace; i++){
		var obscureChar = (isNaN(ccNumber_str.charAt(i))) ? ccNumber_str.charAt(i) : "*";
		obscureCC_str += obscureChar;
	}
	obscureCC_str += clearNumbers_str;
	var summaryMsg_str = _global.appStrings.PAYMENT_METHOD_LBL_str + " " + this.payMethod_cb.getValue() + " " + _global.appStrings.NUMBER_SYMBOL_str + " " + obscureCC_str + newline;
	summaryMsg_str += _global.appStrings.CC_EXPIRATION_DATE_LBL_str + "  " + this.expiryMonth_cb.getValue() + _global.appStrings.DATE_SEPARATOR_str + this.expiryYear_cb.getValue();
	summary_txt.text = summaryMsg_str;
}

//----------------------------------------------------------------------
// opening
//
// 	This function is called when the UI widget is opening.
//----------------------------------------------------------------------
PaymentMethodsUI.prototype.opening = function() {
	Selection.setFocus(this.payMethod_cb);
}

//----------------------------------------------------------------------
// validateAndNotifyCheckout
//----------------------------------------------------------------------
PaymentMethodsUI.prototype.validateAndNotifyCheckout = function() {
	if(this.validate()) {
		this.checkout.sendOrder();
	}
}

//----------------------------------------------------------------------
// validate
//
// 	All of the fields have a status icon with two frames: "required" and
// 	"error".  By moving the playhead for those clips, we can give feedback.
//
// 	This function should return a boolean indicating whether the
// 	validation was successful.
//----------------------------------------------------------------------
PaymentMethodsUI.prototype.validate = function() {
	var isValid = true;
	var now = new Date();
	this.payMethodStatusIcon_mc.gotoAndStop("required");
	this.ccNumberFld_mc.statusIcon_mc.gotoAndStop("required");
	this.expiryMonthStatusIcon_mc.gotoAndStop("required");
	this.expiryYearStatusIcon_mc.gotoAndStop("required");
	this.ccNumberFld_mc.input_txt.text = ValidatorClass.prototype.trim(this.ccNumberFld_mc.input_txt.text);
	this.getCCValidator().setIndicatedCardType(this.payMethod_cb.getSelectedItem().data);
	if(this.payMethod_cb.getSelectedItem().data == "") {
		isValid = false;
		_global.errorBox(this.strings.VALIDATE_PAYMENT_ERROR_TITLE_str, this.strings.VALIDATE_SELECT_CC_TYPE_ERROR_MSG_str, "focus", _global.focuse.setFocusee(this.payMethod_cb));
		this.payMethodStatusIcon_mc.gotoAndStop("error");
	}
	else if(this.expiryMonth_cb.getSelectedItem().data == "") {
		isValid = false;
		_global.errorBox(this.strings.VALIDATE_PAYMENT_ERROR_TITLE_str, this.strings.VALIDATE_SELECT_CC_MO_ERROR_MSG_str, "focus", _global.focuse.setFocusee(this.expiryMonth_cb));
		this.expiryMonthStatusIcon_mc.gotoAndStop("error");
	}
	else if(this.expiryYear_cb.getSelectedItem().data == "") {
		isValid = false;
		_global.errorBox(this.strings.VALIDATE_PAYMENT_ERROR_TITLE_str, this.strings.VALIDATE_SELECT_CC_YR_ERROR_MSG_str, "focus", _global.focuse.setFocusee(this.expiryYear_cb));
		this.expiryYearStatusIcon_mc.gotoAndStop("error");
	}
	else if(now.getFullYear() > this.expiryYear_cb.getSelectedItem().data || 
			(now.getFullYear()  == this.expiryYear_cb.getSelectedItem().data &&
			 now.getMonth() + 1 > this.expiryMonth_cb.getSelectedItem().data)) {
		isValid = false;
		_global.errorBox(this.strings.VALIDATE_PAYMENT_ERROR_TITLE_str, this.strings.VALIDATE_CC_EXPIRED_ERROR_MSG_str, "focus", _global.focuse.setFocusee(this.expiryYear_cb));
		this.expiryYearStatusIcon_mc.gotoAndStop("error");
	}
	
	return isValid;
}

#endinitclip 
//Authors: Brian Kruse (bkruse), Buck Bito (bbito)
