// Copyright 2002 Macromedia, Inc. and its licensors.  All Rights Reserved.
//
// Use and/or redistribution of this file, in whole or in part, is subject
// to the Macromedia Sample Files License, which was distributed with this file.
//
//
/*

CheckoutWidgetGroupUI class


	The CheckoutWidgetGroupUI class encapsulates all UI behavior pertaining to
	the opening and closing of the checkout experience Section widgets.


	The class is meant to be used as singleton- it shouldn't be instantiated.  
	All access should go through the _global.checkoutWidgetGroupObj

	This file is a pure ActionScript object that takes movie clip instances.

	#include info for this file:

			FLA:				main.fla

			Layer:				Actions : Class Definitions

			Frame:				1

			Library Symbol:		N/A

			Library Path:		N/A


*/
//

//
//----------------------------------------------------------------------
//	CheckoutWidgetGroup
//----------------------------------------------------------------------
CheckoutWidgetGroup = function()
{
}
_global.checkoutWidgetGroupObj = new CheckoutWidgetGroup();


CheckoutWidgetGroup.prototype.widgetStack_array = new Array();
CheckoutWidgetGroup.prototype.currentOpenWidget = null;
CheckoutWidgetGroup.prototype.animationSteps = 5;
CheckoutWidgetGroup.prototype.titleOpenTextColor = 0x333333;
CheckoutWidgetGroup.prototype.titleClosedTextColor = 0x333333;
CheckoutWidgetGroup.prototype.titleSummaryTextColor = 0xDDDDDD;
CheckoutWidgetGroup.prototype.summaryHeadBGUpColor = 0x999999;
CheckoutWidgetGroup.prototype.summaryHeadBGOverColor = 0x333333;

//----------------------------------------------------------------------
// addWidget
//----------------------------------------------------------------------
CheckoutWidgetGroup.prototype.addWidget = function(widget_mc, tabcontroller, tabGroup, tabIndex)
{
	this.widgetStack_array.push(widget_mc);
	widget_mc.headBG_mc.widgetGroup = this;
	this.tabcontroller = tabcontroller;
	widget_mc.headBG_mc.tabGroup = tabGroup;
	widget_mc.headBG_mc.enabledTabIndex= tabIndex;
	widget_mc.headBG_mc.onRollOver = CheckoutWidgetGroup.prototype.doHeadRollOver;
	widget_mc.headBG_mc.onRollOut = CheckoutWidgetGroup.prototype.doHeadRollOut;
	widget_mc.headBG_mc.onReleaseOutside = CheckoutWidgetGroup.prototype.doHeadRollOut;
	widget_mc.headBG_mc.enabled = false;
	widget_mc.headBG_mc.editLabel_txt.text = _global.appStrings.EDIT_LBL_str;
	widget_mc.stackOrder = this.widgetStack_array.length - 1;
	widget_mc.base_y = widget_mc._y;
	widget_mc.y2 = widget_mc._y;
	widget_mc.closedHeight = widget_mc.headBG_mc._height;
	widget_mc.summaryHeight = widget_mc.summaryContent_mc._height;
	widget_mc.openHeight = widget_mc.openContent_mc._height;
	widget_mc.openContent_mc.continue_ib.widgetGroup = this;
	this.setWidgetStateClosed(widget_mc);
}

//----------------------------------------------------------------------
// doHeadRollOver
//----------------------------------------------------------------------
CheckoutWidgetGroup.prototype.doHeadRollOver = function()
{
	var bgColor = new Color(this.checkoutSummaryHeadBG_mc);
	bgColor.setRGB(CheckoutWidgetGroup.prototype.summaryHeadBGOverColor);
}

//----------------------------------------------------------------------
// doHeadRollOut
//----------------------------------------------------------------------
CheckoutWidgetGroup.prototype.doHeadRollOut = function()
{
	var bgColor = new Color(this.checkoutSummaryHeadBG_mc);
	bgColor.setRGB(CheckoutWidgetGroup.prototype.summaryHeadBGUpColor);
}

//----------------------------------------------------------------------
// doNext
//
// Called when proceeding linearly through checkout.
//----------------------------------------------------------------------
CheckoutWidgetGroup.prototype.doNext = function(closingWidget_mc)
{
	this.setWidgetStateSummary(closingWidget_mc);
	var nextWidget = closingWidget_mc.nextWidget != undefined ?
						closingWidget_mc.nextWidget :
							this.widgetStack_array[closingWidget_mc.stackOrder + 1];
	this.toggleWidget(nextWidget);
	return nextWidget;
}


//----------------------------------------------------------------------
// setWidgetBottomCap
//
// Bottom cap obscures the bottom of the checkout for aesthetics.
//----------------------------------------------------------------------
CheckoutWidgetGroup.prototype.setWidgetBottomCap = function(widgetBottomCap_mc)
{
	this.widgetBottomCap_mc = widgetBottomCap_mc;
	this.widgetBottomCap_mc.max_y = widgetBottomCap_mc._y + widgetBottomCap_mc._height;
	this.widgetBottomCap_mc._visible = false;
}

//----------------------------------------------------------------------
// getWidgetHeight
//----------------------------------------------------------------------
CheckoutWidgetGroup.prototype.getWidgetHeight = function(widget_mc)
{
	return widget_mc[widget_mc.state+"Height"];
}

//----------------------------------------------------------------------
// getWidgetContentHeight
//----------------------------------------------------------------------
CheckoutWidgetGroup.prototype.getWidgetContentHeight = function(widget_mc)
{
	return this.getWidgetHeight(widget_mc) - widget_mc.closedHeight;
}

//----------------------------------------------------------------------
// setWidgetStateOpen
//----------------------------------------------------------------------
CheckoutWidgetGroup.prototype.setWidgetStateOpen = function(widget_mc)
{
	if(widget_mc.state != "open"){
		widget_mc.openContent_mc._visible = true;
		widget_mc.openContent_mc.opening();
		widget_mc.summaryContent_mc._visible = false;
		widget_mc.headBG_mc.gotoAndStop("open");
		widget_mc.sectionHead_txt.textColor = CheckoutWidgetGroup.prototype.titleOpenTextColor;
		widget_mc.headBG_mc.editLabel_txt._visible = false;
		widget_mc.state = "open";
	}
}

//----------------------------------------------------------------------
// setWidgetStateSummary
//----------------------------------------------------------------------
CheckoutWidgetGroup.prototype.setWidgetStateSummary = function(widget_mc)
{
	if(widget_mc.state != "summary"){
		widget_mc.openContent_mc._visible = false;
		widget_mc.summaryContent_mc._visible = true;
		widget_mc.headBG_mc.enabled = true;
		this.tabcontroller.setTab(widget_mc.headBG_mc.tabGroup, widget_mc.headBG_mc, widget_mc.headBG_mc.enabledTabIndex);
		widget_mc.headBG_mc.gotoAndStop("summary");
		widget_mc.sectionHead_txt.textColor = CheckoutWidgetGroup.prototype.titleSummaryTextColor;
		widget_mc.headBG_mc.editLabel_txt._visible = true;
		widget_mc.openContent_mc.copyToSummary();// :TEMP: Testing ONLY
		widget_mc.state = "summary";
	}
}

//----------------------------------------------------------------------
// setWidgetStateClosed
//----------------------------------------------------------------------
CheckoutWidgetGroup.prototype.setWidgetStateClosed = function(widget_mc)
{
	if(widget_mc.state != "closed"){
		widget_mc.openContent_mc._visible = false;
		widget_mc.summaryContent_mc._visible = false;
		widget_mc.headBG_mc.gotoAndStop("closed");
		widget_mc.sectionHead_txt.textColor = CheckoutWidgetGroup.prototype.titleClosedTextColor;
		widget_mc.headBG_mc.editLabel_txt._visible = false;
		widget_mc.state = "closed";
	}
}

//----------------------------------------------------------------------
// setLocked
//----------------------------------------------------------------------
CheckoutWidgetGroup.prototype.setLocked = function(lock)
{
	if(lock){
		if(this.locked != true){
			this.locked = true;
			for(i=0; i<this.widgetStack_array.length; i++){
				var widget_mc = this.widgetStack_array[i];
				if(widget_mc.state != "summary" || widget_mc.state != "locked"){
					this.setWidgetStateSummary(widget_mc);
				}
				widget_mc.headBG_mc.gotoAndStop("closed");
				widget_mc.sectionHead_txt.textColor = CheckoutWidgetGroup.prototype.titleClosedTextColor;
				widget_mc.headBG_mc.enabled = false;
				widget_mc.state = "locked";
			}
		}
	}
	else if(this.locked){
		this.locked = false;
		for(i=0; i<this.widgetStack_array.length; i++){
			var widget_mc = this.widgetStack_array[i];
			this.setWidgetStateSummary(widget_mc);
		}
	}
}


//----------------------------------------------------------------------
// getCurrentWidget
//----------------------------------------------------------------------
CheckoutWidgetGroup.prototype.getCurrentWidget = function() {
	return this.currentOpenWidget;
}

//----------------------------------------------------------------------
// toggleWidget
//----------------------------------------------------------------------
CheckoutWidgetGroup.prototype.toggleWidget = function(widget_mc)
{
	widget_mc.isDone = true;
	var openOffset = 0;
	if (this.currentOpenWidget != null) { // There is a current widget
		this.setWidgetStateSummary(this.currentOpenWidget);  
		if(this.currentOpenWidget != widget_mc){  
			this.currentOpenWidget = widget_mc;
			this.setWidgetStateOpen(widget_mc);
		}
		else{ 
			// collapse it and make sure last widget is showing
			this.setWidgetStateSummary(widget_mc);
			this.currentOpenWidget = this.widgetStack_array[this.widgetStack_array.length - 1];
			this.setWidgetStateOpen(this.currentOpenWidget);
		}
	}
	else { 
		this.setWidgetStateOpen(widget_mc);
		widget_mc.openContent_mc._visible = true;
		this.currentOpenWidget = widget_mc;
	}

	var l = this.widgetStack_array.length;
	for(i=0; i<l; i++){
		var curr_mc = this.widgetStack_array[i];
		var next_mc = this.widgetStack_array[i+1];
		next_mc.y2 = curr_mc.y2 + this.getWidgetHeight(curr_mc);
		if(next_mc._y != next_mc.y2){
			next_mc.steps = this.animationSteps;
			next_mc.counter = 1;
			next_mc.yInc = (next_mc.y2 - next_mc._y) / next_mc.steps;
			next_mc.onEnterFrame = CheckoutWidgetGroup.prototype.doWidgetAnimation;
		}
	}

	// Set up the animation for the widgets that must move.
	var last_mc = this.widgetStack_array[l-1];
	var stackBottom = last_mc.y2 + last_mc[last_mc.state+"Height"];		
	this.widgetBottomCap_mc.y2 = stackBottom;
	this.widgetBottomCap_mc.steps = this.animationSteps;
	this.widgetBottomCap_mc.counter = 1;
	this.widgetBottomCap_mc.yInc = (this.widgetBottomCap_mc.y2 - this.widgetBottomCap_mc._y) / this.widgetBottomCap_mc.steps;
	this.widgetBottomCap_mc.maskHeightInc = ((this.widgetBottomCap_mc.max_y - this.widgetBottomCap_mc.y2) - this.widgetBottomCap_mc._height) /  this.widgetBottomCap_mc.steps;
	this.widgetBottomCap_mc.onEnterFrame = CheckoutWidgetGroup.prototype.doWidgetAnimation;
	this.isBusy = true;

	return this.currentOpenWidget;
}

//----------------------------------------------------------------------
// doWidgetAnimation
//
// Called by onEnterFrame event.
//----------------------------------------------------------------------
CheckoutWidgetGroup.prototype.doWidgetAnimation = function () {
	if (this.counter <= this.steps) {
		this._y += this.yInc;
		if(this.maskHeightInc != null){
			this._height += this.maskHeightInc;
		}
		this.counter++;
	}
	else{
		delete this.onEnterFrame;
		this._y = this.y2;
	}
}

//Authors: Brian Kruse (bkruse), Buck Bito (bbito)
