// Copyright 2002 Macromedia, Inc. and its licensors.  All Rights Reserved.
//
// Use and/or redistribution of this file, in whole or in part, is subject
// to the Macromedia Sample Files License, which was distributed with this file.
//
#initclip
//
//
/*
//
ItemsUI class

	The ItemsUI class encapsulates all UI behavior pertaining to item browsing.
	In particular, it handles item description, item pictures, and third tier 
	navigation (e.g. M/F, adult/kitten).


	This file is associated with a library movie clip symbol.

	#include info for this file:

			FLA:				main.fla

			Layer:				Actions : Class

			Frame:				1

			Library Symbol:		itemBrowsing_mc

			Library Path:		ItemBrowsing/itemBrowsing_mc
//
*/
//

//----------------------------------------------------------------------
//ItemsUI
//----------------------------------------------------------------------
function ItemsUI() {
	_global.itemBrowsing_mc = this;
	this._visible = false;
}

// Associate the ItemsUI class with the authortime itemBrowsing_mc instance.
Object.registerClass("ItemBrowsingSymbol", ItemsUI);


ItemsUI.prototype = new MovieClip();

//----------------------------------------------------------------------
// init
//----------------------------------------------------------------------
ItemsUI.prototype.init = function(tabController, strings, catalog, cart) {
	this.tabController = tabController;
	this.strings = strings;
	this.catalog = catalog;
	this.cart = cart;

	this.itemNameLabel_txt.text = strings.ITEM_LBL_str;
	this.qtyAvailableLabel_txt.text = strings.QTY_AVAILABLE_LBL_str;
	this.itemPriceLabel_txt.text = strings.PRICE_LBL_str;

	this.items_lb._visible = false;
	this.tabController.setTab("ItemsUI", this.items_lb, 
			TabConstants.prototype.ItemsUIStartTab);
	this.items_lb.controller = this;
	this.items_lb.selectAndStartDragging = ItemsUI.prototype.selectAndStartDragging;
	this.items_lb.stopDragging = ItemsUI.prototype.stopDragging;
	this.items_lb.isOnTarget = ItemsUI.prototype.isOnTarget;
	this.items_lb.setAutoHideScrollBar(true);
	this.items_lb.setItemSymbol("FPCItemListItemSymbol");
	this.items_lb.measureItmHgt();
	_global.sizeAndFormatListBox(this.items_lb, 4);
	this.items_lb.setChangeHandler("showItemDesc", this);
	this.items_lb.dragSymbol = "draggedItemSymbol";

	this.addToCart_ib._visible = false;
	this.tabController.setTab("ItemsUI", this.addToCart_ib, 
			TabConstants.prototype.ItemsUIStartTab + 1);
	_global.sizeAndFormatIconBtn(this.addToCart_ib, strings.ADD_TO_CART_BTN_LBL_str, _global.formIconBtnFormat, true);
	this.addToCart_ib.setChangeHandler("addToCartBtnHandler", this);
	this.productJPGMask_mc._x = this.productJPG_holder_mc._x += _global.productImageXOffset;
	this.productJPGMask_mc._y = this.productJPG_holder_mc._y += _global.productImageYOffset;
	if(_global.productImageMaskFrame_str != "default"){
		this.productJPGMask_mc.gotoAndStop(_global.productImageMaskFrame_str);
	}
}

ItemsUI.prototype.startListening = function() {
	seasar.event.Broadcaster.addEventListener("getItems", this);
	seasar.event.Broadcaster.addEventListener("browseNewProduct", this);
	seasar.event.Broadcaster.addEventListener("notifyProductAnimationComplete", this);
}

ItemsUI.prototype.getItemsPerformed = function(rs) {
	if (rs.getLength() > 0) {
		if (this.readyForItems) { 
			this.drawItems(rs, 0);
		} else {
			this.cachedItems = rs;
		}
	}
}

ItemsUI.prototype.browseNewProductPerformed = function(data) {
	this.readyForItems = false;
	this.cachedItems = undefined;
	this.catalog.getItems(data.prod["PRODUCTOID"]);
}

ItemsUI.prototype.notifyProductAnimationCompletePerformed = function(data) {
	this.showAddToCartBtn(false);
	this.items_lb.itemBulletColor = data.color;
	this.showProduct(data.prodRec);
	if (this.cachedItems != undefined) { 
		this.drawItems(this.cachedItems, 0);
	} else {
		this.readyForItems = true;
	}
}

//----------------------------------------------------------------------
// setDragTarget
//
// 	The drag target must implement a function called acceptDrag and the 
// 	target is responsible for determining what to do with dropped data.
//----------------------------------------------------------------------
ItemsUI.prototype.setDragTarget = function(dragTarget) {
	this.items_lb.dragTarget = dragTarget;
}

//----------------------------------------------------------------------
// drawItems
//----------------------------------------------------------------------
ItemsUI.prototype.drawItems = function(recordset) {
	this.items_lb._visible = true;
	_global.rsToComponent(this.items_lb, recordset, "ITEMNAME", "ITEMOID");
	this.items_lb.setScrollPosition(0);
	this.itemDesc_txt.text = this.strings.CHOOSE_ITEM_HINT_str;
}


//----------------------------------------------------------------------
// showProduct
//----------------------------------------------------------------------
ItemsUI.prototype.showProduct = function(product_record) {
	this.productJPG_holder_mc.setMask(this.productJPGMask_mc);
	var JPG = product_record["IMAGE"];
	var URL = _global.productImagePath_str + JPG;
	this.productJPG_holder_mc.productJPG_mc.loadMovie(URL);
	this.productName_txt.text = product_record["NAME"];
	this.productDesc_txt.text = product_record["DESCRIPTION"];
}


//----------------------------------------------------------------------
// showAddToCartBtn
//----------------------------------------------------------------------
ItemsUI.prototype.showAddToCartBtn = function(bool) {
	if(bool || bool == undefined){
		this.addToCart_ib._visible = true;
	}
	else{
		this.addToCart_ib._visible = false;
	}
}

//----------------------------------------------------------------------
// addToCartBtnHandler
//----------------------------------------------------------------------
ItemsUI.prototype.addToCartBtnHandler = function(btn) {
	var itm = this.items_lb.getSelectedItem().data;
	itm.COLOR = this.items_lb.itemBulletColor;
	this.cart.addCartItem(itm);
}

//----------------------------------------------------------------------
// showItemDesc
//----------------------------------------------------------------------
ItemsUI.prototype.showItemDesc= function (lb)
{
	var curr_item_record = lb.getSelectedItem().data;
	var curr_item_desc = curr_item_record["DESCRIPTION"];
	if(curr_item_record != null && curr_item_record["QUANTITY"] > 0) {
		this.itemDesc_txt.text = curr_item_desc +"  "+ this.strings.ADD_ITEM_TO_CART_HINT_str;
		this.showAddToCartBtn(true);
	}
	else {
		this.itemDesc_txt.text = curr_item_desc +"  "+ this.strings.ITEM_UNAVAILABLE_HINT_str;
		this.showAddToCartBtn(false);
	}
}

//----------------------------------------------------------------------
// selectAndStartDragging
//
// In function below, this = items_lb.item[n].highlight_mc.
// 
// This function attaches a drag icon to the cursor and associates
// data with the drag icon.
//----------------------------------------------------------------------
ItemsUI.prototype.selectAndStartDragging = function() {
    if (this.controller.enable && this.draggedItem_mc == undefined) {
		var lb = this.controller.controller;
		// Seems like listbox loses first click for some reason.
		if(!lb.firstClickKludge) {
			lb.firstClickKludge = true;
			lb.clickHandler(this.controller.itemNum);
		}
		lb.clickHandler(this.controller.itemNum);
    	var itm = lb.getSelectedItem();
		if(itm.data["QUANTITY"] > 0) {
			var lb_parent = lb._parent._parent;
			lb_parent.createEmptyMovieClip("draggedItem_holder", 1000000)
			lb_parent.draggedItem_holder.attachMovie(lb.dragSymbol, "draggedItem_mc", 1000000);
			this.draggedItem_mc = lb_parent.draggedItem_holder;
			this.draggedItem_mc.dest = lb.dragTarget;
			itm.data.COLOR = lb.itemBulletColor;
			this.draggedItem_mc.item = itm;
			this.draggedItem_mc._x = _root._xmouse;
			this.draggedItem_mc._y = _root._ymouse;
			this.draggedItem_mc.isOnTarget = lb.isOnTarget;
			this.draggedItem_mc.startDrag();
		}
    }
}

//----------------------------------------------------------------------
// stopDragging
//
// 	In function below, this = items_lb.item[n].highlight_mc.
//
// 	This function checks if the drag ended up over the drag target and
// 	adds it to cart if it did.
//----------------------------------------------------------------------
ItemsUI.prototype.stopDragging = function() {
	if(this.draggedItem_mc != undefined) {
		this.draggedItem_mc.stopDrag();
		if(this.draggedItem_mc.isOnTarget(eval(this.draggedItem_mc._droptarget))) {
        	var lb = this.controller.controller;
			lb.controller.cart.addCartItem(this.draggedItem_mc.item.data);
		}
		this.draggedItem_mc.removeMovieClip();
		this.draggedItem_mc = undefined;
	}
}

//----------------------------------------------------------------------
// isOnTarget
//
// 	In function below, this = draggedItem_mc.
//
//	This function checks if the dropClip is a child of our destClip.
//----------------------------------------------------------------------
ItemsUI.prototype.isOnTarget = function(dropClip) {
	var ret = false;
	var cc = dropClip;
	while(!ret && cc != null) {
		ret = cc == this.dest;
		cc = cc._parent;
	}
	return ret;
}

#endinitclip