// Copyright 2002 Macromedia, Inc. and its licensors.  All Rights Reserved.
//
// Use and/or redistribution of this file, in whole or in part, is subject
// to the Macromedia Sample Files License, which was distributed with this file.
//
//
/*

       

WidgetGroupUI class


	The WidgetGroupUI class encapsulates all UI behavior pertaining to
	the opening and closing of search, history, cart, and advertisement
	widgets.


	The class is meant to be used as a singleton - it shouldn't be instantiated,
	and all access should go through the _global.widgetGroupObj

	This file is a pure ActionScript object that takes movie clip instances.

	#include info for this file:

			FLA:				main.fla

			Layer:				Actions : Class Definitions

			Frame:				1

			Library Symbol:		N/A

			Library Path:		N/A


*/
//
//----------------------------------------------------------------------
//	WidgetGroup
//----------------------------------------------------------------------
WidgetGroup = function() {
}

_global.widgetGroupObj = new WidgetGroup();

//----------------------------------------------------------------------
// startListening
//----------------------------------------------------------------------
WidgetGroup.prototype.startListening = function() {
	seasar.event.Broadcaster.addEventListener("doCheckout", this);
	seasar.event.Broadcaster.addEventListener("continueShopping", this);
}

WidgetGroup.prototype.doCheckoutPerformed= function(data){
	this.doCheckout();
}

WidgetGroup.prototype.continueShoppingPerformed= function(data){
	this.continueShopping();
}

WidgetGroup.prototype.widgetStack_array = new Array();
WidgetGroup.prototype.currentWidget = null;
//----------------------------------------------------------------------
// addWidget
//----------------------------------------------------------------------
WidgetGroup.prototype.addWidget = function(widget_mc, checkoutY, checkoutSteps)
{
	this.widgetStack_array.push(widget_mc);
	widget_mc.stackOrder = this.widgetStack_array.length - 1;
	widget_mc.base_y = widget_mc._y;
	widget_mc.closedHeight = widget_mc.headBG_mc._height;
	widget_mc.openHeight = widget_mc.openContent_mc._height;
	widget_mc.headBG_mc.widgetGroup = this;
	widget_mc.headBG_mc.onPress = WidgetGroup.prototype.widgetBtnPressed;
	widget_mc.headBG_mc.onRelease = WidgetGroup.prototype.doHeadRollOver;
	widget_mc.headBG_mc.onRollOver = WidgetGroup.prototype.doHeadRollOver;
	widget_mc.headBG_mc.onRollOut = WidgetGroup.prototype.doHeadRollOut;
	widget_mc.headBG_mc.onReleaseOutside = WidgetGroup.prototype.doHeadRollOut;
}

//----------------------------------------------------------------------
// addCartWidget
//----------------------------------------------------------------------
WidgetGroup.prototype.addCartWidget = function(widget_mc, checkoutY, checkoutSteps)
{
	widget_mc.checkoutY = checkoutY;
	widget_mc.checkoutSteps = checkoutSteps;
	this.cart_mc = widget_mc;
	this.addWidget(widget_mc);
}

//----------------------------------------------------------------------
// widgetBtnPressed
//
// In function below this = headBG_mc.
//----------------------------------------------------------------------
WidgetGroup.prototype.widgetBtnPressed = function()
{
	this.widgetGroup.toggleWidget(this._parent);
	this._parent.widgetIconButtonBG_mc.gotoAndStop("_down");
}

//----------------------------------------------------------------------
// doHeadRollOver
//
// In function below this = headBG_mc.
//----------------------------------------------------------------------
WidgetGroup.prototype.doHeadRollOver = function()
{
	this._parent.widgetIconButtonBG_mc.gotoAndStop("_over");
}

//----------------------------------------------------------------------
// doHeadRollOut
//
// In function below this = headBG_mc.
//----------------------------------------------------------------------
WidgetGroup.prototype.doHeadRollOut = function()
{
	this._parent.widgetIconButtonBG_mc.gotoAndStop("_up");
}

//----------------------------------------------------------------------
// setAdWidget
//----------------------------------------------------------------------
WidgetGroup.prototype.setAdWidget = function(adWidget_mc, adMask_mc, maskBase_y, maskMax_y)
{
	this.ad_mc = adWidget_mc;
	this.adMask_mc = adMask_mc;
	this.adMask_mc.base_y = maskBase_y;
	this.adMask_mc.max_y = maskMax_y;
	this.ad_mc.setMask(this.adMask_mc);
}

//----------------------------------------------------------------------
// setCartBottom_mc
//----------------------------------------------------------------------
WidgetGroup.prototype.setCartBottom_mc = function(cartBottom_mc, adMaskOffset, checkoutY, checkoutSteps)
{
	this.cartBottom_mc = cartBottom_mc;
	this.cartBottom_mc.adMaskOffset = adMaskOffset;
	this.cartBottom_mc.checkoutY = checkoutY;
	this.cartBottom_mc.checkoutSteps = checkoutSteps;
}

//----------------------------------------------------------------------
// toggleWidget
//----------------------------------------------------------------------
WidgetGroup.prototype.toggleWidget = function(widget_mc)
{
	var openOffset = 0;
	if (this.currentWidget != null) { // There is a current widget
		if(this.currentWidget != widget_mc){ // widget_mc is not current widget
			this.closingWidget = this.currentWidget;
			this.closingWidget.toggleWidget(false);
			widget_mc.toggleWidget(true);
			widget_mc.openContent_mc._visible = true;
			this.currentWidget = widget_mc;
			openOffset = widget_mc.openHeight - widget_mc.closedHeight;
		}
		else{ // widget_mc is current widget
			this.closingWidget = widget_mc;
			widget_mc.toggleWidget(false);
			this.currentWidget = null;
		}
	}
	else { // There is no current widget
		widget_mc.toggleWidget(true);
		widget_mc.openContent_mc._visible = true;
		this.currentWidget = widget_mc;
		openOffset = widget_mc.openHeight - widget_mc.closedHeight;
		this.closingWidget = null;
	}
	this.currentWidget.widgetExpanderArrow_mc.gotoAndPlay("playOpen");
	this.closingWidget.widgetExpanderArrow_mc.gotoAndPlay("playClose");
	var l = this.widgetStack_array.length;
	for(i=0; i<l; i++){
		if(i<=widget_mc.stackOrder){
			if(this.widgetStack_array[i]._y != this.widgetStack_array[i].base_y){
				this.widgetStack_array[i].y2 = this.widgetStack_array[i].base_y;
				this.widgetStack_array[i].steps = 5;
				this.widgetStack_array[i].counter = 1;
				this.widgetStack_array[i].yInc = (this.widgetStack_array[i].y2 - this.widgetStack_array[i]._y) / this.widgetStack_array[i].steps;
				this.widgetStack_array[i].onEnterFrame = WidgetGroup.prototype.doWidgetAnimation;
			}
		}
		else{
			this.widgetStack_array[i].y2 = this.widgetStack_array[i].base_y + openOffset;
			this.widgetStack_array[i].steps = 5;
			this.widgetStack_array[i].counter = 1;
			this.widgetStack_array[i].yInc = (this.widgetStack_array[i].y2 - this.widgetStack_array[i]._y) / this.widgetStack_array[i].steps;
			this.widgetStack_array[i].onEnterFrame = WidgetGroup.prototype.doWidgetAnimation;
		}
	}
	this.adMask_mc.y2 = this.adMask_mc.base_y + openOffset;
	this.adMask_mc.steps = 5;
	this.adMask_mc.counter = 1;
	this.adMask_mc.yInc = (this.adMask_mc.y2 - this.adMask_mc._y) / this.adMask_mc.steps;
	this.adMask_mc.onEnterFrame = WidgetGroup.prototype.doWidgetAnimation;
	this.cartBottom_mc.y2 = this.adMask_mc.y2 + this.cartBottom_mc.adMaskOffset;
	this.cartBottom_mc.steps = 5;
	this.cartBottom_mc.counter = 1;
	this.cartBottom_mc.yInc = (this.cartBottom_mc.y2 - this.cartBottom_mc._y) / this.cartBottom_mc.steps;
	this.cartBottom_mc.onEnterFrame = WidgetGroup.prototype.doWidgetAnimation;
	this.isBusy = true;
}

//----------------------------------------------------------------------
// collapseAll
//----------------------------------------------------------------------
WidgetGroup.prototype.collapseAll = function () {
	if(this.currentWidget != null) {
		this.toggleWidget(this.currentWidget);
	}
}

//----------------------------------------------------------------------
// doWidgetAnimation
//
// This function is called for each onEnterFrame event.
//----------------------------------------------------------------------
WidgetGroup.prototype.doWidgetAnimation = function () {
	if (this.counter <= this.steps) {
		this._y += this.yInc;
		this.counter++;
	}
	else{
		this._y = this.y2;
		this.openContent_mc._visible = this.isOpen;
		delete this.onEnterFrame;
	}
}

//----------------------------------------------------------------------
// doCheckout
//----------------------------------------------------------------------
WidgetGroup.prototype.doCheckout = function () {
	this.toggleForCheckout(true);
}

//----------------------------------------------------------------------
// continueShopping
//----------------------------------------------------------------------
WidgetGroup.prototype.continueShopping = function () {
	this.toggleForCheckout(false);
}

//----------------------------------------------------------------------
// toggleForCheckout
//
// 	Moves the cart widget up to the top for checkout mode or restores
// 	the widget group state if leaving checkout mode.
//----------------------------------------------------------------------
WidgetGroup.prototype.toggleForCheckout = function (hideOthers) {
	if(this.currentWidget != this.cart_mc){
		this.toggleWidget(this.cart_mc);
	}
	var l = this.widgetStack_array.length;
	var i;
	for(i=0; i<l; i++){
		if(this.widgetStack_array[i] != this.cart_mc) {
			this.widgetStack_array[i]._visible = !hideOthers;
		}
	}
	this.ad_mc._visible = !hideOthers;
	this.adMask_mc._visible = !hideOthers;
	this.cart_mc.toggleForCheckout(hideOthers);
	this.cart_mc.y2 = (hideOthers) ? this.cart_mc.checkoutY : this.cart_mc.base_y;
	this.cart_mc.steps = this.cart_mc.checkoutSteps;
	this.cart_mc.yInc = (this.cart_mc.y2 - this.cart_mc._y) / this.cart_mc.steps;
	this.cartBottom_mc.y2 = (hideOthers) ? this.cartBottom_mc.checkoutY : (this.cart_mc.y2 + this.cart_mc.openHeight);
	this.cartBottom_mc.steps = this.cartBottom_mc.checkoutSteps;
	this.cartBottom_mc.yInc = (this.cartBottom_mc.y2 - this.cartBottom_mc._y) / this.cartBottom_mc.steps;
	this.cart_mc.counter  = this.cartBottom_mc.counter = 1;
	this.cart_mc.onEnterFrame = WidgetGroup.prototype.doWidgetAnimation;
	this.cartBottom_mc.onEnterFrame = WidgetGroup.prototype.doWidgetAnimation;
}



//Authors: Brian Kruse (bkruse), Buck Bito (bbito)
