package test.petmarket.rule.user;

import java.util.Date;
import java.util.Map;

import org.seasar.nazuna.Nazuna;
import org.seasar.nazuna.unit.NazunaTestCase;
import org.seasar.util.SeasarException;
import org.seasar.util.Struct;

import petmarket.rule.RuleNames;


public class UpdateCreditCardTest extends NazunaTestCase implements RuleNames {

	public UpdateCreditCardTest(String arg0) {
		super(arg0);
	}

	public void testValidateUser() throws Exception {
		try {
			Nazuna.executeUpdate(UPDATE_CREDIT_CARD, (Object) null);
			fail("1");
		} catch (SeasarException ex) {
			System.out.println(ex);
		}
	}

	public void testExecute() throws Exception {
		Struct user = (Struct) Nazuna.execute(ADD_USER, "hoge", "hoge");
		user.put("creditcardnumber", "creditcardnumber");
		user.put("creditcardtype", "creditcardtype");
		Date d = new Date();
		user.put("creditcardexpiry", d);
		int num = Nazuna.executeUpdate(UPDATE_CREDIT_CARD, (Object) user);
		assertEquals("1", 1, num);
		Map user2 = (Map) Nazuna.executeSingleQuery(GET_USER, "hoge");
		assertNotNull("2", user2);
		assertEquals("3", "creditcardnumber", user2.get("creditcardnumber"));
		assertEquals("4", "creditcardtype", user2.get("creditcardtype"));
		assertEquals("5", d, user2.get("creditcardexpiry"));
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(UpdateCreditCardTest.class);
	}

	protected void setUp() throws Exception {
		super.setUp();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}
}
