// Copyright 2002 Macromedia, Inc. and its licensors.  All Rights Reserved.
//
// Use and/or redistribution of this file, in whole or in part, is subject
// to the Macromedia Sample Files License, which was distributed with this file.
//
#initclip 3
/*
		FPCItemListItemClass
		EXTENDS FSelectableItemClass
		This is a customized List Item

*/

//----------------------------------------------------------------------
//FPCItemListItemClass
//----------------------------------------------------------------------
function FPCItemListItemClass()
{
	this.init();
}

FPCItemListItemClass.prototype = new FSelectableItemClass();
Object.registerClass("FPCItemListItemSymbol", FPCItemListItemClass);

// This over-rides the layoutContent method in FSelectable class
FPCItemListItemClass.prototype.layoutContent = function(width)
{
};

//----------------------------------------------------------------------
// displayContent
//
//  this is the function that must be implemented to display the custom
//  list item content
//----------------------------------------------------------------------
FPCItemListItemClass.prototype.displayContent = function(itmObj, selected)
{
	var itemRecord = itmObj.data;
	this.itemName_txt.text = itmObj.label;
	this.itemPrice_txt.text = _global.formatForCurrency(itemRecord["LISTPRICE"]);
	this.qtyAvailable_txt.text = itemRecord["QUANTITY"];
	var catColor = new Color(this.colorSwatch);
	if (itmObj.label != null){
		catColor.setRGB(this.controller.itemBulletColor);
	}
	else{
		catColor.setRGB(0xFFFFFF);
	}
}

//----------------------------------------------------------------------
// setSize
//
//	this function is overridden to supply drag and drop behaviors
//
//	it exposes hooks only, the actually drag and drop code is in ItemsUI
//	in the selectAndStartDragging and the stopDragging functions
//----------------------------------------------------------------------
FPCItemListItemClass.prototype.setSize = function(w, h) {
	super.setSize(w, h);
	var lb = this.controller;
	this.highlight_mc.onPress = lb.selectAndStartDragging;
	this.highlight_mc.onDragOver = undefined;
	this.highlight_mc.trackAsMenu = false;
	this.highlight_mc.onRelease = this.highlight_mc.onReleaseOutside = lb.stopDragging;
}


#endinitclip
