#include "seasar/nazuna/NzNetServices.as"
#include "seasar/lang/SObject.as"
#include "seasar/event/Broadcaster.as"
#include "petmarket/service/catalog/Catalog.as"
#include "petmarket/service/cart/Cart.as"
#include "petmarket/service/user/User.as"
#include "petmarket/strings/AppStrings.as"

if (petmarket.form.Main === undefined) {
	seasar.lang.SObject.defineClass("petmarket.form.Main", null,
		["main_mc", "catalog", "cart", "user", "navigationInited", "adWidgetInited",
		"cartWidgetInited", "searchWidgetInited", "histWidgetInited",
		"topNavInited", "widgetGroupInited"],
		function(main_mc) {
			super();
			this.main_mc = main_mc;
			this.navigationInited = false;
			this.adWidgetInited = false;
			this.cartWidgetInited = false;
			this.searchWidgetInited = false;
			this.histWidgetInited = false;
			this.topNavInited = false;
			this.widgetGroupInited = false;
			seasar.event.Broadcaster.addEventListener("newCartOid", this);
			seasar.event.Broadcaster.addEventListener("getShippingMethodsServer", this);
			seasar.event.Broadcaster.addEventListener("getCategories", this);
			seasar.event.Broadcaster.addEventListener("getProductsStatus", this);
			seasar.event.Broadcaster.addEventListener("browseNewProduct", this);
			seasar.event.Broadcaster.addEventListener("doCheckout", this);
			seasar.event.Broadcaster.addEventListener("continueShopping", this);
		});
		
	var proto = petmarket.form.Main.prototype;
	
	proto.init = function() {
		this.initRuleService();
	}
	
	proto.initRuleService = function() {
		var conn = seasar.nazuna.NzNetServices.setup("http://localhost:8080/petmarket/gateway");
		this.catalog = new petmarket.service.catalog.Catalog(conn);
		this.cart = new petmarket.service.cart.Cart(conn);
		this.user = new petmarket.service.user.User(conn);
	}
	
	proto.initAppStrings = function() {
		_global.shell.setInitFeedback("load", _global.APP_STRINGS_LOADING_MSG_str);
		_global.appStrings = new petmarket.strings.AppStrings();
	}
	
	proto.initCheckoutWidgets = function () {
		var checkoutWidget_mc = this.main_mc.checkoutWidget_mc;
		_global.checkoutWidgetGroupObj.addWidget(checkoutWidget_mc.profileFlds_mc, _global.tabController, "ProfileUI", TabConstants.prototype.ProfileUIStartTab);
		_global.checkoutWidgetGroupObj.addWidget(checkoutWidget_mc.billingFlds_mc, _global.tabController, "BillingFieldsUI", TabConstants.prototype.BillingFieldsUIStartTab);
		_global.checkoutWidgetGroupObj.addWidget(checkoutWidget_mc.shippingFlds_mc, _global.tabController, "ShippingFieldsUI", TabConstants.prototype.ShippingFieldsUIStartTab);
		_global.checkoutWidgetGroupObj.addWidget(checkoutWidget_mc.shippingMethodFlds_mc, _global.tabController, "ShippingMethodsUI", TabConstants.prototype.ShippingMethodsUIStartTab);
		_global.checkoutWidgetGroupObj.addWidget(checkoutWidget_mc.paymentFlds_mc, _global.tabController, "PaymentMethodsUI", TabConstants.prototype.PaymentMethodsUIStartTab);
		_global.checkoutWidgetGroupObj.setWidgetBottomCap(checkoutWidget_mc.checkoutBottomCap_mc);
		checkoutWidget_mc.init(_global.tabController, _global.checkoutWidgetGroupObj,
				_global.appStrings, _global.main.cart, _global.main.user);
		checkoutWidget_mc.startListening();
	}
	
	proto.initAdWidget = function() {
		if (!this.adWidgetInited) {
			this.adWidgetInited = true;
			this.main_mc.adWidget_mc.init(_global.appStrings);
			this.main_mc.adWidget_mc.startListening();
		}
	}
	
	proto.initHistWidget = function() {
		if (!this.histWidgetInited) {
			this.histWidgetInited = true;
			shell.setInitFeedback("init", _global.HISTORY_INIT_MSG_str);
			this.main_mc.historyWidget_mc.init(_global.toolTip_mc, _global.tabController, _global.appStrings, this.catalog);
			this.main_mc.historyWidget_mc.startListening();
		}
	}
	
	proto.initSearchWidget = function() {
		if (!this.searchWidgetInited) {
			this.searchWidgetInited = true;
			shell.setInitFeedback("init", _global.SEARCH_INIT_MSG_str);
			this.main_mc.searchWidget_mc.init(_global.tabController, _global.appStrings, this.catalog);
			this.main_mc.searchWidget_mc.startListening();
		}
	}
	
	proto.initCartWidget = function() {
		if (!this.cartWidgetInited) {
			this.cartWidgetInited = true;
			shell.setInitFeedback("init", _global.CART_INIT_MSG_str);
			this.main_mc.cartWidget_mc.init(_global.tabController, _global.appStrings, this.cart);
			this.main_mc.cartWidget_mc.startListening();
			this.main_mc.itemBrowsing_mc.setDragTarget(this.main_mc.cartWidget_mc);
		}
	}
	
	proto.initWidgetGroup = function() {
		if (!this.widgetGroupInited) {
			this.widgetGroupInited = true;
			_global.widgetGroupObj.addWidget(this.main_mc.historyWidget_mc);
			_global.widgetGroupObj.addWidget(this.main_mc.searchWidget_mc);
			_global.widgetGroupObj.addCartWidget(this.main_mc.cartWidget_mc, 36, 2);
			_global.widgetGroupObj.setAdWidget(this.main_mc.adWidget_mc, this.main_mc.adMask_mc, 261, 442);
			_global.widgetGroupObj.setCartBottom_mc(this.main_mc.cartBottom_mc, -4, 556, 2);
			_global.widgetGroupObj.startListening();
		}
	}
	
	proto.initTopNav = function() {
		if (!this.topNavInited) {
			this.topNavInited = true;
			this.main_mc.topNav_mc.addButton(_global.appStrings.HOME_BTN_LBL_str, "navBtn", "homeBtnCallback");
			this.main_mc.topNav_mc.initButtons();
			this.main_mc.logoHomeBtn_mc.onPress = _global.goHome;
			this.main_mc.logoHomeBtn_mc.useHandCursor = true;
			this.main_mc.topNav_mc.initTabs(_global.tabController);
		}
	}
	
	proto.initNavigation = function() {
		if (!this.navigationInited) {
			this.navigationInited = true;
			shell.setInitFeedback("init", _global.PRODUCT_BROWSING_INIT_MSG_str);
			itemBrowsing_mc.init(_global.tabController, _global.appStrings, this.catalog, this.cart);
			itemBrowsing_mc.startListening();
			_global.categoryUI.init(_global.tabController, this.catalog, catNav_holder_mc, productNav_holder_mc);
			_global.categoryUI.startListening();
			this.getCategories();
		}
	}
	
	proto.showWelcomeStrings = function() {
		this.main_mc.welcomeHeadline_txt.text = _global.appStrings.WELCOME_PREFIX_HD_str + _global.appTitle_str;
		this.main_mc.welcomeBody_txt.text = _global.appStrings.WELCOME_BODY_str;
	}
	
	proto.newCartOid = function() {
		this.main_mc.stop();
		this.cart.newCartOid();
	}
	
	proto.newCartOidPerformed = function(cartOid) {
		this.main_mc.play();
	}
	
	proto.getShippingMethodsServer = function() {
		if (this.cart.shippingMethods == null) {
			this.main_mc.stop();
			this.cart.getShippingMethodsServer();
		}
	}
	
	proto.getShippingMethodsServerPerformed = function(rs) {
		this.main_mc.play();
	}
	
	proto.getCategories = function() {
		this.main_mc.stop();
		this.catalog.getCategories();
	}
	
	proto.getCategoriesPerformed = function(data) {
		this.main_mc.play();
	}
	
	proto.getProducts = function(categoryoid) {
		this.catalog.getProducts(categoryoid);
	}
	
	proto.getProductsStatusPerformed = function(exception) {
		this.main_mc.itemBrowsing_mc._visible = false;
		_global.categoryUI.reset();
		this.main_mc.gotoAndStop("home");
	}
	
	proto.browseNewProductPerformed = function(data) {
		if (this.main_mc.currUIState == "home"){
			this.main_mc.gotoAndPlay("firstCategory");
		} else{
			this.main_mc.gotoAndStop("productSelected");
		}
	}

	proto.doCheckoutPerformed = function(data) {
		_global.tabController.resetTabs("CategoryUI", "ItemsUI", "HistoryUI", "SearchUI");
		_global.tabController.restoreTabs("ProfileUI", "BillingFieldsUI", 
				"ShippingFieldsUI", "ShippingMethodsUI", "PaymentMethodsUI");
		_global.categoryUI.setEnabled(false);
		this.main_mc.gotoAndPlay("checkout");
	}
	
	proto.continueShoppingPerformed = function(data) {
		_global.tabController.restoreTabs("CategoryUI", "ItemsUI", "HistoryUI", "SearchUI");
		_global.tabController.resetTabs("ProfileUI", "BillingFieldsUI", 
				"ShippingFieldsUI", "ShippingMethodsUI", "PaymentMethodsUI");
		_global.categoryUI.setEnabled(true);
		this.main_mc.shouldReset = data.resetToHome;
		this.main_mc.needNewCart = data.needNewCart;
		if (data.needNewCart) {
			this.cart.newCartOid();
		}
		this.main_mc.gotoAndPlay("exitCheckout");
	}
	
	delete proto;
}