#include "seasar/lang/SObject.as"
	
if (petmarket.form.Shell === undefined) {
	seasar.lang.SObject.defineClass("petmarket.form.Shell", null,
		["shell_mc", "target_mc", "loadedStateLabel", "splashInited", "inited"],
		function(shell_mc) {
			super();
			this.shell_mc = shell_mc;
			this.splashInited = false;
			this.inited = false;
		});
		
	var proto = petmarket.form.Shell.prototype;
		
	proto.loadFonts = function() {
		trace("loadFonts");
		this.shell_mc.stop();
		this.loadSwf("embed_fonts.swf", this.shell_mc.embed_fonts_mc, "loadedFonts");
	}
	
	proto.loadComponents = function() {
		trace("loadComponents");
		this.shell_mc.stop();
		this.loadSwf("fui_components.swf", this.shell_mc.fui_components_mc, "loadedComponents");
	}
	
	proto.loadMain = function() {
		if (_global.testMovieMain === undefined){
			_global.testMovieMain = false;
			trace("loadMain");
			this.shell_mc.stop();
			this.loadSwf("main.swf", this.shell_mc.main_mc, "loadedMain");
		}
	}
	
	proto.loadSwf = function(swfToLoad, targetMC, loadedStateLabel) {
		this.target_mc = targetMC;
		this.loadedStateLabel = loadedStateLabel;
		targetMC.loadMovie(swfToLoad);
		if (this.shell_mc.loadPoller === undefined) {
			this.shell_mc.createEmptyMovieClip("loadPoller", 10);
			this.shell_mc.loadPoller.onEnterFrame = this.updateLoading;
		}
	}
	
	proto.updateLoading = function() {
		var bytesLoaded = shell.target_mc.getBytesLoaded();
		var bytesTotal = shell.target_mc.getBytesTotal();
		if (bytesTotal > 4 && bytesLoaded >= bytesTotal) {
			shell.shell_mc.gotoAndStop(shell.loadedStateLabel);
		} else {
			shell.updateLoadingFeedback();
		}
	}
	
	proto.updateLoadingFeedback = function() {
		var upperCaseName_str = this.target_mc._name.toUpperCase();
		this.showSplashScreen(true);
		this.shell_mc.splash_mc.loadingMsg_txt.text = _global.LOADING_str;
		this.shell_mc.splash_mc.loadingStatus_txt.text = _global[upperCaseName_str+"_LOADING_MSG_str"];
	}
	
	proto.mainIsLoaded = function() {
		delete this.shell_mc.loadPoller.onEnterFrame;
		this.shell_mc.stop();
	}
	
	proto.setInitFeedback = function(mode, elt_str) {
		this.showSplashScreen(true);
		this.shell_mc.splash_mc.loadingMsg_txt.text = (mode == "load") ? _global.LOADING_str : _global.INITIALIZING_str;
		this.shell_mc.splash_mc.loadingStatus_txt.text = elt_str;
	}
	
	proto.finishInitFeedback = function() {
		this.showSplashScreen(false);
	}
	
	proto.showSplashScreen = function(show) {
		if (show) {
			if (!this.splashInited) {
				this.splashInited = true;
				this.shell_mc.attachMovie("shellSplash_mc", "splash_mc", 999999);
				this.shell_mc.splash_mc._x = 207;
				this.shell_mc.splash_mc._y = 92;
				this.shell_mc.splash_mc.splashBG_mc._alpha = 75;
				this.shell_mc.splash_mc.onPress = function(){};
				this.shell_mc.splash_mc.useHandCursor = false;
			}
		} else {
			this.shell_mc.splash_mc.removeMovieClip();
			this.splashInited = false;
		}
	}

	proto.getShellInitData = function() {
		trace("getShellInitData");
		_global.adImagePath_str = "images/";
		_global.productImagePath_str = "images/";
		_global.productImageXOffset = 0;
		_global.productImageYOffset = 0;
		_global.appTitle_str = "Pet Market";
		_global.appSubtitle_str = "blueprint application";
		_global.LOADING_str = "Loading";
		_global.EMBED_FONTS_MC_LOADING_MSG_str = "Font Outlines";
		_global.FUI_COMPONENTS_MC_LOADING_MSG_str = "User Interface Components";
		_global.MAIN_MC_LOADING_MSG_str = "Shopping Interface";
		_global.APP_STRINGS_LOADING_MSG_str = "Localized Text";
		_global.INITIALIZING_str = "Initializing";
		_global.PRODUCT_BROWSING_INIT_MSG_str = "Pet Browser";
		_global.CART_INIT_MSG_str = "Shopping Cart";
		_global.SEARCH_INIT_MSG_str = "Search Interface";
		_global.HISTORY_INIT_MSG_str = "History Interface";
		this.shell_mc.gotoAndPlay("loadFonts");
	}

	delete proto;
}
