#include "seasar/lang/SObject.as"
#include "seasar/nazuna/RuleEventService.as"
#include "seasar/nazuna/NzRecordSet.as"
#include "seasar/event/Broadcaster.as"
	
if (petmarket.service.cart.GetShippingMethods === undefined) {
	seasar.lang.SObject.defineClass("petmarket.service.cart.GetShippingMethods", seasar.nazuna.RuleEventService,
		cart,
		function(conn, cart) {
			super(conn, "petmarket.rule.cart.GetShippingMethods",
				"getShippingMethodsServer", "getShippingMethodsServerStatus");
			this.cart = cart;
		});
		
	var proto = petmarket.service.cart.GetShippingMethods.prototype;
	
	proto.execute = function () {
		trace("getShippingMethodsServer");
		this.rule.executeRSQuery();
	}
	
	proto.onResult = function(rs) {
		this.cart.shippingMethods = rs;
		super.onResult(rs);
	}
	
	delete proto;
}