#include "seasar/lang/SObject.as"
#include "seasar/nazuna/RuleEventService.as"
	
if (petmarket.service.user.AddUser === undefined) {
	seasar.lang.SObject.defineClass("petmarket.service.user.AddUser", seasar.nazuna.RuleEventService,
		"user",
		function(conn, user) {
			super(conn, "petmarket.rule.user.AddUser", "addUser", "addUserStatus");
			this.user = user;
		});
		
	var proto = petmarket.service.user.AddUser.prototype;
	
	proto.execute = function(email, passwd) {
		trace("addUser:email=" + email);
		this.rule.execute(email, passwd);
	}
	
	proto.onResult = function(userData) {
		this.user.userData = userData;
		super.onResult(userData);
	}
	
	delete proto;
}