#include "seasar/lang/SObject.as"
#include "petmarket/service/user/AddUser.as"
#include "petmarket/service/user/GetUser.as"
#include "petmarket/service/user/UpdateUser.as"
	
if (petmarket.service.user.User === undefined) {
	seasar.lang.SObject.defineClass("petmarket.service.user.User", null,
		["userData", "addUser_svc", "getUser_srv", "updateUser_srv"],
		function(conn) {
			this.addUser_svc = new petmarket.service.user.AddUser(conn, this);
			this.getUser_svc = new petmarket.service.user.GetUser(conn, this);
			this.updateUser_svc = new petmarket.service.user.UpdateUser(conn, this);
		});
		
	var proto = petmarket.service.user.User.prototype;
	
	proto.addUser = function(email, passwd) {
		this.addUser_svc.execute(email, passwd);
	}
	
	proto.getUser = function(email, passwd) {
		this.getUser_svc.execute(email, passwd);
	}
	
	proto.updateUser = function() {
		this.updateUser_svc.execute();
	}
	
	proto.getUserData = function() {
		return this.userData;
	}

	delete proto;
}