#include "NetServices.as"
#include "seasar/lang/SObject.as"
#include "seasar/unit/TestCase.as"
#include "seasar/event/Broadcaster.as"
#include "petmarket/service/catalog/Catalog.as"

if (test.petmarket.service.catalog.CatalogTest === undefined) {
	seasar.lang.SObject.defineClass("test.petmarket.service.catalog.CatalogTest",
		seasar.unit.TestCase, ["catalog"]);
	
	var proto = test.petmarket.service.catalog.CatalogTest.prototype;
	
	proto.setUp = function() {
		NetServices.setDefaultGatewayUrl("http://localhost:8080/petmarket/gateway");
		var conn = NetServices.createGatewayConnection();
		this.catalog = new petmarket.service.catalog.Catalog(conn);
	}
	
	proto.tearDown = function() {
		this.catalog = null;
	}
	
	proto.testGetCategories = function() {
		var listener = new Object();
		listener.getCategoriesPerformed = function(data) {
			trace("listener.getCategoriesPerformed:" + data.getLength());
		}
		seasar.event.Broadcaster.addEventListener("getCategories", listener);
		this.catalog.getCategories();
	}
	
	proto.testGetProducts = function() {
		var listener = new Object();
		listener.getProductsPerformed = function(data) {
			trace("listener.getProductsPerformed:" + data.getLength());
		}
		seasar.event.Broadcaster.addEventListener("getProducts", listener);
		this.catalog.getProducts(1);
	}
	
	proto.testSearchProducts = function() {
		var listener = new Object();
		listener.searchProductsPerformed = function(data) {
			trace("listener.searchProductsPerformed:" + data.getLength());
		}
		seasar.event.Broadcaster.addEventListener("searchProducts", listener);
		this.catalog.searchProducts("dog");
	}
	
	proto.testGetItems = function() {
		var listener = new Object();
		listener.getItemsPerformed = function(data) {
			trace("listener.getItemsPerformed:" + data.getLength());
		}
		seasar.event.Broadcaster.addEventListener("getItems", listener);
		this.catalog.getItems(96);
	}

	delete proto;
}