#include "NetServices.as"
#include "seasar/lang/SObject.as"
#include "seasar/unit/TestCase.as"
#include "seasar/event/Broadcaster.as"
#include "petmarket/service/catalog/SearchProducts.as"

if (test.petmarket.service.catalog.SearchProductsTest === undefined) {
	seasar.lang.SObject.defineClass("test.petmarket.service.catalog.SearchProductsTest",
		seasar.unit.TestCase, ["service"]);
	
	var proto = test.petmarket.service.catalog.SearchProductsTest.prototype;
	
	proto.setUp = function() {
		NetServices.setDefaultGatewayUrl("http://localhost:8080/petmarket/gateway");
		var conn = NetServices.createGatewayConnection();
		this.service = new petmarket.service.catalog.SearchProducts(conn);
	}
	
	proto.tearDown = function() {
		this.service = null;
	}
	
	proto.testExecute = function() {
		var listener = new Object();
		listener.searchProductsPerformed = function(data) {
			trace("listener.searchProductsPerformed:" + data.getLength());
		}
		seasar.event.Broadcaster.addEventListener("searchProducts", listener);
		this.service.execute("dog");
	}

	delete proto;
}